/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.runners;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.InputStream;
import java.lang.reflect.Method;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.protocol.asserts.unmarshalling.UnmarshallingTestContext;
import software.amazon.awssdk.protocol.model.GivenResponse;
import software.amazon.awssdk.protocol.model.TestCase;
import software.amazon.awssdk.protocol.reflect.ClientReflector;
import software.amazon.awssdk.utils.IoUtils;

class UnmarshallingTestRunner {
    private final IntermediateModel model;
    private final Metadata metadata;
    private final ClientReflector clientReflector;

    UnmarshallingTestRunner(IntermediateModel model, ClientReflector clientReflector) {
        this.model = model;
        this.metadata = model.getMetadata();
        this.clientReflector = clientReflector;
    }

    void runTest(TestCase testCase) throws Exception {
        this.resetWireMock(testCase.getGiven().getResponse());
        String operationName = testCase.getWhen().getOperationName();
        if (!this.hasStreamingMember(operationName)) {
            Object actualResult = this.clientReflector.invokeMethod(testCase, this.createRequestObject(operationName));
            testCase.getThen().getUnmarshallingAssertion().assertMatches(this.createContext(operationName), actualResult);
        } else {
            CapturingResponseTransformer responseHandler = new CapturingResponseTransformer();
            Object actualResult = this.clientReflector.invokeStreamingMethod(testCase, this.createRequestObject(operationName), responseHandler);
            testCase.getThen().getUnmarshallingAssertion().assertMatches(this.createContext(operationName, responseHandler.captured), actualResult);
        }
    }

    private boolean hasStreamingMember(String operationName) {
        return ((ShapeModel)this.model.getShapes().get(operationName + "Response")).isHasStreamingMember();
    }

    private void resetWireMock(GivenResponse givenResponse) {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlMatching((String)".*")).willReturn(this.toResponseBuilder(givenResponse)));
    }

    private ResponseDefinitionBuilder toResponseBuilder(GivenResponse givenResponse) {
        ResponseDefinitionBuilder responseBuilder = WireMock.aResponse().withStatus(200);
        if (givenResponse.getHeaders() != null) {
            givenResponse.getHeaders().forEach((x$0, xva$1) -> responseBuilder.withHeader(x$0, new String[]{xva$1}));
        }
        if (givenResponse.getStatusCode() != null) {
            responseBuilder.withStatus(givenResponse.getStatusCode().intValue());
        }
        if (givenResponse.getBody() != null) {
            responseBuilder.withBody(givenResponse.getBody());
        } else if (this.metadata.isXmlProtocol()) {
            responseBuilder.withBody("<foo></foo>");
        }
        return responseBuilder;
    }

    private Object createRequestObject(String operationName) throws Exception {
        String requestClassName = this.getModelFqcn(this.getOperationRequestClassName(operationName));
        Class<?> requestClass = Class.forName(requestClassName);
        Method builderMethod = null;
        try {
            builderMethod = requestClass.getDeclaredMethod("builder", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (builderMethod != null) {
            builderMethod.setAccessible(true);
            Object builderInstance = builderMethod.invoke(null, new Object[0]);
            Method buildMethod = builderInstance.getClass().getDeclaredMethod("build", new Class[0]);
            buildMethod.setAccessible(true);
            return buildMethod.invoke(builderInstance, new Object[0]);
        }
        return requestClass.newInstance();
    }

    private UnmarshallingTestContext createContext(String operationName) {
        return this.createContext(operationName, null);
    }

    private UnmarshallingTestContext createContext(String operationName, String streamedResponse) {
        return new UnmarshallingTestContext().withModel(this.model).withOperationName(operationName).withStreamedResponse(streamedResponse);
    }

    private String getModelFqcn(String simpleClassName) {
        return String.format("%s.%s", this.metadata.getFullModelPackageName(), simpleClassName);
    }

    private String getOperationRequestClassName(String operationName) {
        return ((OperationModel)this.model.getOperations().get(operationName)).getInput().getVariableType();
    }

    private static class CapturingResponseTransformer
    implements ResponseTransformer<Object, Void> {
        private String captured;

        private CapturingResponseTransformer() {
        }

        public Void transform(Object response, AbortableInputStream inputStream) throws Exception {
            this.captured = IoUtils.toUtf8String((InputStream)inputStream);
            return null;
        }
    }
}

