/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.unmarshalling;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.protocol.asserts.unmarshalling.UnmarshallingAssertion;
import software.amazon.awssdk.protocol.asserts.unmarshalling.UnmarshallingTestContext;
import software.amazon.awssdk.protocol.reflect.ShapeModelReflector;

public class UnmarshalledResultAssertion
extends UnmarshallingAssertion {
    private final JsonNode expectedResult;

    public UnmarshalledResultAssertion(JsonNode expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    protected void doAssert(UnmarshallingTestContext context, Object actual) throws Exception {
        ShapeModelReflector shapeModelReflector = this.createShapeReflector(context);
        Object expectedResult = shapeModelReflector.createShapeObject();
        for (Field field : expectedResult.getClass().getDeclaredFields()) {
            this.assertFieldEquals(field, actual, expectedResult);
        }
        if (context.getStreamedResponse() != null) {
            Assert.assertEquals((Object)shapeModelReflector.getStreamingMemberValue(), (Object)context.getStreamedResponse());
        }
    }

    private void assertFieldEquals(Field field, Object actual, Object expectedResult) throws Exception {
        field.setAccessible(true);
        if (field.getType().isAssignableFrom(InputStream.class)) {
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)((InputStream)field.get(expectedResult)), (InputStream)((InputStream)field.get(actual))));
        } else {
            ReflectionAssert.assertReflectionEquals((Object)field.get(expectedResult), (Object)field.get(actual), (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
        }
    }

    private ShapeModelReflector createShapeReflector(UnmarshallingTestContext context) {
        return new ShapeModelReflector(context.getModel(), this.getOutputClassName(context), this.expectedResult);
    }

    private String getOutputClassName(UnmarshallingTestContext context) {
        return ((OperationModel)context.getModel().getOperations().get(context.getOperationName())).getReturnType().getReturnType();
    }
}

