/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import org.junit.Assert;
import software.amazon.awssdk.protocol.asserts.marshalling.MarshallingAssertion;

public class JsonBodyAssertion
extends MarshallingAssertion {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String jsonEquals;

    public JsonBodyAssertion(String jsonEquals) {
        this.jsonEquals = jsonEquals;
    }

    @Override
    protected void doAssert(LoggedRequest actual) throws Exception {
        JsonNode expected = MAPPER.readTree(this.jsonEquals);
        JsonNode actualJson = MAPPER.readTree(actual.getBodyAsString());
        Assert.assertEquals((Object)expected, (Object)actualJson);
    }
}

