/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.reflect;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.protocol.reflect.TestCaseReflectionException;
import software.amazon.awssdk.utils.Validate;

public class ShapeModelReflector {
    private final IntermediateModel model;
    private final String shapeName;
    private final JsonNode input;

    public ShapeModelReflector(IntermediateModel model, String shapeName, JsonNode input) {
        this.model = (IntermediateModel)Validate.paramNotNull((Object)model, (String)"model");
        this.shapeName = (String)Validate.paramNotNull((Object)shapeName, (String)"shapeName");
        this.input = input;
    }

    public Object createShapeObject() {
        try {
            return this.createStructure((ShapeModel)this.model.getShapes().get(this.shapeName), this.input);
        }
        catch (Exception e) {
            throw new TestCaseReflectionException(e);
        }
    }

    public String getStreamingMemberValue() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.input.fields(), 16), false).filter(f -> ((ShapeModel)this.model.getShapes().get(this.shapeName)).getMemberByC2jName((String)f.getKey()).getHttp().getIsStreaming()).map(f -> ((JsonNode)f.getValue()).asText()).findFirst().orElseThrow(() -> new IllegalStateException("Streaming member not found in " + this.shapeName));
    }

    private Object createStructure(ShapeModel structureShape, JsonNode input) throws Exception {
        String fqcn = this.getFullyQualifiedModelClassName(structureShape.getShapeName());
        Class<?> shapeClass = Class.forName(fqcn);
        Method builderMethod = null;
        try {
            builderMethod = shapeClass.getDeclaredMethod("builder", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (builderMethod != null) {
            builderMethod.setAccessible(true);
            Object builderInstance = builderMethod.invoke(null, new Object[0]);
            if (input != null) {
                this.initializeFields(structureShape, input, builderInstance);
            }
            Method buildMethod = builderInstance.getClass().getDeclaredMethod("build", new Class[0]);
            buildMethod.setAccessible(true);
            return buildMethod.invoke(builderInstance, new Object[0]);
        }
        Object shapeObject = Class.forName(fqcn).newInstance();
        if (input != null) {
            this.initializeFields(structureShape, input, shapeObject);
        }
        return shapeObject;
    }

    private void initializeFields(ShapeModel structureShape, JsonNode input, Object shapeObject) throws Exception {
        Iterator fieldNames = input.fieldNames();
        while (fieldNames.hasNext()) {
            String memberName = (String)fieldNames.next();
            MemberModel memberModel = structureShape.getMemberByC2jName(memberName);
            if (memberModel == null) {
                throw new IllegalArgumentException("Member " + memberName + " was not found in the " + structureShape.getC2jName() + " shape.");
            }
            Object toSet = this.getMemberValue(input.get(memberName), memberModel);
            if (toSet == null) continue;
            Method setter = this.getMemberSetter(shapeObject.getClass(), memberModel);
            setter.setAccessible(true);
            setter.invoke(shapeObject, toSet);
        }
    }

    private String getFullyQualifiedModelClassName(String modelClassName) {
        return String.format("%s.%s", this.model.getMetadata().getFullModelPackageName(), modelClassName);
    }

    private Method getMemberSetter(Class<?> containingClass, MemberModel currentMember) throws Exception {
        return containingClass.getMethod("set" + currentMember.getName(), Class.forName(this.getFullyQualifiedType(currentMember)));
    }

    private String getFullyQualifiedType(MemberModel memberModel) {
        if (memberModel.isSimple()) {
            switch (memberModel.getVariable().getSimpleType()) {
                case "Date": 
                case "ByteBuffer": 
                case "InputStream": {
                    return memberModel.getSetterModel().getVariableSetterType();
                }
            }
            return "java.lang." + memberModel.getSetterModel().getVariableSetterType();
        }
        if (memberModel.isList()) {
            return "java.util.Collection";
        }
        if (memberModel.isMap()) {
            return "java.util.Map";
        }
        return this.getFullyQualifiedModelClassName(memberModel.getSetterModel().getVariableSetterType());
    }

    private Object getMemberValue(JsonNode currentNode, MemberModel memberModel) {
        if (currentNode.isNull()) {
            return null;
        }
        if (memberModel.isSimple()) {
            return this.getSimpleMemberValue(currentNode, memberModel);
        }
        if (memberModel.isList()) {
            return this.getListMemberValue(currentNode, memberModel);
        }
        if (memberModel.isMap()) {
            return this.getMapMemberValue(currentNode, memberModel);
        }
        ShapeModel structureShape = (ShapeModel)this.model.getShapes().get(memberModel.getVariable().getVariableType());
        try {
            return this.createStructure(structureShape, currentNode);
        }
        catch (Exception e) {
            throw new TestCaseReflectionException(e);
        }
    }

    private Object getMapMemberValue(JsonNode currentNode, MemberModel memberModel) {
        HashMap map = new HashMap();
        currentNode.fields().forEachRemaining(e -> map.put(e.getKey(), this.getMemberValue((JsonNode)e.getValue(), memberModel.getMapModel().getValueModel())));
        return map;
    }

    private Object getListMemberValue(JsonNode currentNode, MemberModel memberModel) {
        ArrayList list = new ArrayList();
        currentNode.elements().forEachRemaining(e -> list.add(this.getMemberValue((JsonNode)e, memberModel.getListModel().getListMemberModel())));
        return list;
    }

    private Object getSimpleMemberValue(JsonNode currentNode, MemberModel memberModel) {
        if (memberModel.getHttp().getIsStreaming()) {
            return null;
        }
        switch (memberModel.getVariable().getSimpleType()) {
            case "Long": {
                return currentNode.asLong();
            }
            case "Integer": {
                return currentNode.asInt();
            }
            case "String": {
                return currentNode.asText();
            }
            case "Boolean": {
                return currentNode.asBoolean();
            }
            case "Double": {
                return currentNode.asDouble();
            }
            case "Date": {
                return new Date(currentNode.asLong());
            }
            case "ByteBuffer": {
                return ByteBuffer.wrap(currentNode.asText().getBytes(StandardCharsets.UTF_8));
            }
            case "Float": {
                return Float.valueOf((float)currentNode.asDouble());
            }
            case "Character": {
                return this.asCharacter(currentNode);
            }
        }
        throw new IllegalArgumentException("Unsupported fieldType " + memberModel.getVariable().getSimpleType());
    }

    private Character asCharacter(JsonNode currentNode) {
        String text = currentNode.asText();
        if (text != null && text.length() > 1) {
            throw new IllegalArgumentException("Invalid character " + currentNode.asText());
        }
        if (text != null && text.length() == 1) {
            return Character.valueOf(currentNode.asText().charAt(0));
        }
        return null;
    }
}

