/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.math.BigInteger;
import java.util.Objects;
import org.junit.Assert;
import software.amazon.awssdk.protocol.asserts.marshalling.MarshallingAssertion;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.Timestamp;
import software.amazon.ion.system.IonSystemBuilder;

public class IonBodyAssertion
extends MarshallingAssertion {
    private static final double DOUBLE_DELTA = 1.0E-4;
    private static final IonSystem ION_SYSTEM = IonSystemBuilder.standard().build();
    private final String ionEquals;

    public IonBodyAssertion(String ionEquals) {
        this.ionEquals = ionEquals;
    }

    @Override
    protected void doAssert(LoggedRequest request) throws Exception {
        IonReader expected = ION_SYSTEM.newReader(this.ionEquals);
        IonReader actual = ION_SYSTEM.newReader(request.getBody());
        this.assertIonReaderEquals(expected, actual);
    }

    private void assertIonReaderEquals(IonReader x, IonReader y) {
        int token = 0;
        while (true) {
            block20: {
                IonType xType;
                block22: {
                    boolean yNull;
                    boolean xNull;
                    block21: {
                        IonType yType;
                        block19: {
                            xType = x.next();
                            yType = y.next();
                            if (xType != null || yType != null) break block19;
                            if (x.getDepth() == 0 && y.getDepth() == 0) {
                                return;
                            }
                            x.stepOut();
                            y.stepOut();
                            break block20;
                        }
                        if (!Objects.equals(xType, yType)) {
                            Assert.fail((String)String.format("Types (%s, %s) are unequal at token %s", xType, yType, token));
                        }
                        if (x.isInStruct() && y.isInStruct()) {
                            String xFieldName = x.getFieldName();
                            String yFieldName = y.getFieldName();
                            Assert.assertEquals((String)String.format("Unequal field names (%s, %s) at token %s", xFieldName, yFieldName, token), (Object)xFieldName, (Object)yFieldName);
                        }
                        xNull = x.isNullValue();
                        yNull = y.isNullValue();
                        if ((!xNull || yNull) && (!yNull || xNull)) break block21;
                        Assert.fail((String)String.format("One value is null but the other is not at token %s", token));
                        break block22;
                    }
                    if (xNull && yNull) break block20;
                }
                switch (xType) {
                    case BLOB: 
                    case CLOB: {
                        int sizeX = x.byteSize();
                        int sizeY = y.byteSize();
                        Assert.assertEquals((String)String.format("Unequal LOB sizes (%s, %s) at token %s", sizeX, sizeY, token), (long)sizeX, (long)sizeY);
                        byte[] bufferX = new byte[sizeX];
                        byte[] bufferY = new byte[sizeY];
                        x.getBytes(bufferX, 0, sizeX);
                        y.getBytes(bufferY, 0, sizeY);
                        Assert.assertArrayEquals((String)String.format("Unequal LOBs at token %s", token), (byte[])bufferX, (byte[])bufferY);
                        break;
                    }
                    case BOOL: {
                        boolean xBoolean = x.booleanValue();
                        boolean yBoolean = y.booleanValue();
                        Assert.assertEquals((String)String.format("Unequal boolean values (%s, %s) at token %s", xBoolean, yBoolean, token), (Object)xBoolean, (Object)yBoolean);
                        break;
                    }
                    case DECIMAL: {
                        Decimal xDecimal = x.decimalValue();
                        Decimal yDecimal = y.decimalValue();
                        Assert.assertEquals((String)String.format("Unequal decimal values (%s, %s) at token %s", xDecimal, yDecimal, token), (Object)xDecimal, (Object)yDecimal);
                        break;
                    }
                    case FLOAT: {
                        double xDouble = x.doubleValue();
                        double yDouble = y.doubleValue();
                        Assert.assertEquals((String)String.format("Unequal float values (%s, %s) at token %s", xDouble, yDouble, token), (double)xDouble, (double)yDouble, (double)1.0E-4);
                        break;
                    }
                    case INT: {
                        BigInteger xInteger = x.bigIntegerValue();
                        BigInteger yInteger = y.bigIntegerValue();
                        Assert.assertEquals((String)String.format("Unequal integer values (%s, %s) at token %s", xInteger, yInteger, token), (Object)xInteger, (Object)yInteger);
                        break;
                    }
                    case LIST: 
                    case SEXP: {
                        x.stepIn();
                        y.stepIn();
                        break;
                    }
                    case NULL: {
                        throw new IllegalStateException("We should never fall through to the IonType.NULL block due to previous assertions for equal types and nullness");
                    }
                    case STRING: 
                    case SYMBOL: {
                        String xString = x.stringValue();
                        String yString = y.stringValue();
                        Assert.assertEquals((String)String.format("Unequal string values (%s, %s) at token %s", xString, yString, token), (Object)xString, (Object)yString);
                        break;
                    }
                    case STRUCT: {
                        x.stepIn();
                        y.stepIn();
                        break;
                    }
                    case TIMESTAMP: {
                        Timestamp xTimestamp = x.timestampValue();
                        Timestamp yTimestamp = y.timestampValue();
                        Assert.assertEquals((String)String.format("Unequal timestamp values (%s, %s) at token %s", xTimestamp, yTimestamp, token), (Object)xTimestamp, (Object)yTimestamp);
                        break;
                    }
                    default: {
                        Assert.fail((String)String.format("Unrecognized IonType %s", xType));
                    }
                }
            }
            ++token;
        }
    }
}

