/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.profiles;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.internal.ProfileFileLocations;
import software.amazon.awssdk.profiles.internal.ProfileFileReader;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@SdkPublicApi
public class ProfileFile {
    private final Map<String, Profile> profiles;

    @SdkInternalApi
    ProfileFile(Map<String, Map<String, String>> rawProfiles) {
        Validate.paramNotNull(rawProfiles, (String)"rawProfiles");
        this.profiles = Collections.unmodifiableMap(this.convertToProfilesMap(rawProfiles));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Aggregator aggregator() {
        return new Aggregator();
    }

    public static ProfileFile defaultProfileFile() {
        return ((Aggregator)((Aggregator)ProfileFile.aggregator().apply(ProfileFile::addCredentialsFile)).apply(ProfileFile::addConfigFile)).build();
    }

    public final Optional<Profile> profile(String profileName) {
        return Optional.ofNullable(this.profiles.get(profileName));
    }

    public final Map<String, Profile> profiles() {
        return this.profiles;
    }

    public String toString() {
        return ToString.builder((String)"ProfileFile").add("profiles", this.profiles.values()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileFile that = (ProfileFile)o;
        return Objects.equals(this.profiles, that.profiles);
    }

    public int hashCode() {
        return Objects.hash(this.profiles);
    }

    private static void addCredentialsFile(Aggregator builder) {
        ProfileFileLocations.credentialsFileLocation().ifPresent(l -> builder.addFile(ProfileFile.builder().content((Path)l).type(Type.CREDENTIALS).build()));
    }

    private static void addConfigFile(Aggregator builder) {
        ProfileFileLocations.configurationFileLocation().ifPresent(l -> builder.addFile(ProfileFile.builder().content((Path)l).type(Type.CONFIGURATION).build()));
    }

    private Map<String, Profile> convertToProfilesMap(Map<String, Map<String, String>> sortedProfiles) {
        LinkedHashMap<String, Profile> result = new LinkedHashMap<String, Profile>();
        for (Map.Entry<String, Map<String, String>> rawProfile : sortedProfiles.entrySet()) {
            Profile profile = Profile.builder().name(rawProfile.getKey()).properties(rawProfile.getValue()).build();
            result.put(profile.name(), profile);
        }
        return result;
    }

    public static final class Aggregator
    implements SdkBuilder<Aggregator, ProfileFile> {
        private List<ProfileFile> files = new ArrayList<ProfileFile>();

        public Aggregator addFile(ProfileFile file) {
            this.files.add(file);
            return this;
        }

        public ProfileFile build() {
            LinkedHashMap<String, Map<String, String>> aggregateRawProfiles = new LinkedHashMap<String, Map<String, String>>();
            for (int i = this.files.size() - 1; i >= 0; --i) {
                this.addToAggregate(aggregateRawProfiles, this.files.get(i));
            }
            return new ProfileFile(aggregateRawProfiles);
        }

        private void addToAggregate(Map<String, Map<String, String>> aggregateRawProfiles, ProfileFile file) {
            Map<String, Profile> profiles = file.profiles();
            for (Map.Entry<String, Profile> profile : profiles.entrySet()) {
                aggregateRawProfiles.compute(profile.getKey(), (k, current) -> {
                    if (current == null) {
                        return new HashMap<String, String>(((Profile)profile.getValue()).properties());
                    }
                    current.putAll(((Profile)profile.getValue()).properties());
                    return current;
                });
            }
        }
    }

    public static final class Builder
    implements SdkBuilder<Builder, ProfileFile> {
        private InputStream content;
        private Path contentLocation;
        private Type type;

        private Builder() {
        }

        public Builder content(InputStream contentStream) {
            this.contentLocation = null;
            this.content = contentStream;
            return this;
        }

        public Builder content(Path contentLocation) {
            Validate.paramNotNull((Object)contentLocation, (String)"profileLocation");
            Validate.validState((boolean)Files.exists(contentLocation, new LinkOption[0]), (String)"Profile file '%s' does not exist.", (Object[])new Object[]{contentLocation});
            this.content = null;
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public ProfileFile build() {
            InputStream stream = this.content != null ? this.content : (InputStream)FunctionalUtils.invokeSafely(() -> Files.newInputStream(this.contentLocation, new OpenOption[0]));
            Validate.paramNotNull((Object)((Object)this.type), (String)"type");
            Validate.paramNotNull((Object)stream, (String)"content");
            try {
                ProfileFile profileFile = new ProfileFile(ProfileFileReader.parseFile(stream, this.type));
                return profileFile;
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)stream, null);
            }
        }
    }

    public static enum Type {
        CONFIGURATION,
        CREDENTIALS;

    }
}

