/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.profiles;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class Profile
implements ToCopyableBuilder<Builder, Profile> {
    private final String name;
    private final Map<String, String> properties;

    private Profile(Builder builder) {
        this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
        this.properties = (Map)Validate.paramNotNull((Object)builder.properties, (String)"properties");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public Optional<String> property(String propertyKey) {
        return Optional.ofNullable(this.properties.get(propertyKey));
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return Profile.builder().name(this.name).properties(this.properties);
    }

    public String toString() {
        return ToString.builder((String)"Profile").add("name", (Object)this.name).add("properties", this.properties.keySet()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.name, profile.name) && Objects.equals(this.properties, profile.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties);
    }

    public static class Builder
    implements CopyableBuilder<Builder, Profile> {
        private String name;
        private Map<String, String> properties;
        private Function<String, Optional<Profile>> credentialsSourceResolver;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, String>(properties));
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }
    }
}

