/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.FileFormatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriceList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriceList> {
    private static final SdkField<String> PRICE_LIST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceListArn").getter(PriceList.getter(PriceList::priceListArn)).setter(PriceList.setter(Builder::priceListArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceListArn").build()}).build();
    private static final SdkField<String> REGION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionCode").getter(PriceList.getter(PriceList::regionCode)).setter(PriceList.setter(Builder::regionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionCode").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(PriceList.getter(PriceList::currencyCode)).setter(PriceList.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<List<String>> FILE_FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileFormats").getter(PriceList.getter(PriceList::fileFormats)).setter(PriceList.setter(Builder::fileFormats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_LIST_ARN_FIELD, REGION_CODE_FIELD, CURRENCY_CODE_FIELD, FILE_FORMATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PriceList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String priceListArn;
    private final String regionCode;
    private final String currencyCode;
    private final List<String> fileFormats;

    private PriceList(BuilderImpl builder) {
        this.priceListArn = builder.priceListArn;
        this.regionCode = builder.regionCode;
        this.currencyCode = builder.currencyCode;
        this.fileFormats = builder.fileFormats;
    }

    public final String priceListArn() {
        return this.priceListArn;
    }

    public final String regionCode() {
        return this.regionCode;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final boolean hasFileFormats() {
        return this.fileFormats != null && !(this.fileFormats instanceof SdkAutoConstructList);
    }

    public final List<String> fileFormats() {
        return this.fileFormats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.priceListArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileFormats() ? this.fileFormats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceList)) {
            return false;
        }
        PriceList other = (PriceList)obj;
        return Objects.equals(this.priceListArn(), other.priceListArn()) && Objects.equals(this.regionCode(), other.regionCode()) && Objects.equals(this.currencyCode(), other.currencyCode()) && this.hasFileFormats() == other.hasFileFormats() && Objects.equals(this.fileFormats(), other.fileFormats());
    }

    public final String toString() {
        return ToString.builder((String)"PriceList").add("PriceListArn", (Object)this.priceListArn()).add("RegionCode", (Object)this.regionCode()).add("CurrencyCode", (Object)this.currencyCode()).add("FileFormats", this.hasFileFormats() ? this.fileFormats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PriceListArn": {
                return Optional.ofNullable(clazz.cast(this.priceListArn()));
            }
            case "RegionCode": {
                return Optional.ofNullable(clazz.cast(this.regionCode()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "FileFormats": {
                return Optional.ofNullable(clazz.cast(this.fileFormats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PriceListArn", PRICE_LIST_ARN_FIELD);
        map.put("RegionCode", REGION_CODE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("FileFormats", FILE_FORMATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PriceList, T> g) {
        return obj -> g.apply((PriceList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String priceListArn;
        private String regionCode;
        private String currencyCode;
        private List<String> fileFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PriceList model) {
            this.priceListArn(model.priceListArn);
            this.regionCode(model.regionCode);
            this.currencyCode(model.currencyCode);
            this.fileFormats(model.fileFormats);
        }

        public final String getPriceListArn() {
            return this.priceListArn;
        }

        public final void setPriceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
        }

        @Override
        public final Builder priceListArn(String priceListArn) {
            this.priceListArn = priceListArn;
            return this;
        }

        public final String getRegionCode() {
            return this.regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Collection<String> getFileFormats() {
            if (this.fileFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileFormats;
        }

        public final void setFileFormats(Collection<String> fileFormats) {
            this.fileFormats = FileFormatsCopier.copy(fileFormats);
        }

        @Override
        public final Builder fileFormats(Collection<String> fileFormats) {
            this.fileFormats = FileFormatsCopier.copy(fileFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileFormats(String ... fileFormats) {
            this.fileFormats(Arrays.asList(fileFormats));
            return this;
        }

        public PriceList build() {
            return new PriceList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriceList> {
        public Builder priceListArn(String var1);

        public Builder regionCode(String var1);

        public Builder currencyCode(String var1);

        public Builder fileFormats(Collection<String> var1);

        public Builder fileFormats(String ... var1);
    }
}

