/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingAsyncClient;
import software.amazon.awssdk.services.pricing.internal.UserAgentUtils;
import software.amazon.awssdk.services.pricing.model.ListPriceListsRequest;
import software.amazon.awssdk.services.pricing.model.ListPriceListsResponse;
import software.amazon.awssdk.services.pricing.model.PriceList;

public class ListPriceListsPublisher
implements SdkPublisher<ListPriceListsResponse> {
    private final PricingAsyncClient client;
    private final ListPriceListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPriceListsPublisher(PricingAsyncClient client, ListPriceListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPriceListsPublisher(PricingAsyncClient client, ListPriceListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPriceListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPriceListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PriceList> priceLists() {
        Function<ListPriceListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.priceLists() != null) {
                return response.priceLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPriceListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPriceListsResponseFetcher
    implements AsyncPageFetcher<ListPriceListsResponse> {
        private ListPriceListsResponseFetcher() {
        }

        public boolean hasNextPage(ListPriceListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPriceListsResponse> nextPage(ListPriceListsResponse previousPage) {
            if (previousPage == null) {
                return ListPriceListsPublisher.this.client.listPriceLists(ListPriceListsPublisher.this.firstRequest);
            }
            return ListPriceListsPublisher.this.client.listPriceLists((ListPriceListsRequest)((Object)ListPriceListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

