/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAttributeValuesResponse extends PricingResponse implements
        ToCopyableBuilder<GetAttributeValuesResponse.Builder, GetAttributeValuesResponse> {
    private static final SdkField<List<AttributeValue>> ATTRIBUTE_VALUES_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .getter(getter(GetAttributeValuesResponse::attributeValues))
            .setter(setter(Builder::attributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAttributeValuesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_VALUES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AttributeValue> attributeValues;

    private final String nextToken;

    private GetAttributeValuesResponse(BuilderImpl builder) {
        super(builder);
        this.attributeValues = builder.attributeValues;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AttributeValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributeValues() {
        return attributeValues != null && !(attributeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
     * <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
     *         <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code>
     *         <code>volumeType</code>.
     */
    public List<AttributeValue> attributeValues() {
        return attributeValues;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttributeValuesResponse)) {
            return false;
        }
        GetAttributeValuesResponse other = (GetAttributeValuesResponse) obj;
        return Objects.equals(attributeValues(), other.attributeValues()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAttributeValuesResponse").add("AttributeValues", attributeValues())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeValues":
            return Optional.ofNullable(clazz.cast(attributeValues()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAttributeValuesResponse, T> g) {
        return obj -> g.apply((GetAttributeValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PricingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAttributeValuesResponse> {
        /**
         * <p>
         * The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
         * <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>
         * .
         * </p>
         * 
         * @param attributeValues
         *        The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
         *        <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code>
         *        <code>volumeType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(Collection<AttributeValue> attributeValues);

        /**
         * <p>
         * The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
         * <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>
         * .
         * </p>
         * 
         * @param attributeValues
         *        The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
         *        <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code>
         *        <code>volumeType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(AttributeValue... attributeValues);

        /**
         * <p>
         * The list of values for an attribute. For example, <code>Throughput Optimized HDD</code> and
         * <code>Provisioned IOPS</code> are two available values for the <code>AmazonEC2</code> <code>volumeType</code>
         * .
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeValue>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributeValues(List<AttributeValue>)}.
         * 
         * @param attributeValues
         *        a consumer that will call methods on {@link List<AttributeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeValues(List<AttributeValue>)
         */
        Builder attributeValues(Consumer<AttributeValue.Builder>... attributeValues);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PricingResponse.BuilderImpl implements Builder {
        private List<AttributeValue> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttributeValuesResponse model) {
            super(model);
            attributeValues(model.attributeValues);
            nextToken(model.nextToken);
        }

        public final Collection<AttributeValue.Builder> getAttributeValues() {
            return attributeValues != null ? attributeValues.stream().map(AttributeValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attributeValues(Collection<AttributeValue> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AttributeValue... attributeValues) {
            attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(Consumer<AttributeValue.Builder>... attributeValues) {
            attributeValues(Stream.of(attributeValues).map(c -> AttributeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeValues(Collection<AttributeValue.BuilderImpl> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copyFromBuilder(attributeValues);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetAttributeValuesResponse build() {
            return new GetAttributeValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
