/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pricing.model.GetProductsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetProductsRequestModelMarshaller {
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceCode").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<String> FORMATVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FormatVersion").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final GetProductsRequestModelMarshaller INSTANCE = new GetProductsRequestModelMarshaller();

    private GetProductsRequestModelMarshaller() {
    }

    public static GetProductsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetProductsRequest getProductsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getProductsRequest), (String)"getProductsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getProductsRequest.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall(getProductsRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)getProductsRequest.formatVersion(), FORMATVERSION_BINDING);
            protocolMarshaller.marshall((Object)getProductsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)getProductsRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

