/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pricing.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AttributeValueMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final AttributeValueMarshaller INSTANCE = new AttributeValueMarshaller();

    private AttributeValueMarshaller() {
    }

    public static AttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AttributeValue attributeValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)attributeValue, (String)"attributeValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)attributeValue.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

