/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;

public class GetAttributeValuesIterable
implements SdkIterable<GetAttributeValuesResponse> {
    private final PricingClient client;
    private final GetAttributeValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAttributeValuesIterable(PricingClient client, GetAttributeValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAttributeValuesResponseFetcher();
    }

    public Iterator<GetAttributeValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetAttributeValuesIterable resume(GetAttributeValuesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetAttributeValuesIterable(this.client, (GetAttributeValuesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetAttributeValuesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetAttributeValuesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetAttributeValuesResponseFetcher
    implements SyncPageFetcher<GetAttributeValuesResponse> {
        private GetAttributeValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetAttributeValuesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public GetAttributeValuesResponse nextPage(GetAttributeValuesResponse previousPage) {
            if (previousPage == null) {
                return GetAttributeValuesIterable.this.client.getAttributeValues(GetAttributeValuesIterable.this.firstRequest);
            }
            return GetAttributeValuesIterable.this.client.getAttributeValues((GetAttributeValuesRequest)((Object)GetAttributeValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

