/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.transform.GetAttributeValuesRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetAttributeValuesRequestMarshaller
implements Marshaller<Request<GetAttributeValuesRequest>, GetAttributeValuesRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSPriceListService.GetAttributeValues").serviceName("AWS Pricing").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetAttributeValuesRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetAttributeValuesRequest> marshall(GetAttributeValuesRequest getAttributeValuesRequest) {
        Validate.paramNotNull((Object)((Object)getAttributeValuesRequest), (String)"getAttributeValuesRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getAttributeValuesRequest);
            protocolMarshaller.startMarshalling();
            GetAttributeValuesRequestModelMarshaller.getInstance().marshall(getAttributeValuesRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

