/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.PollyResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTask;
import software.amazon.awssdk.services.polly.model.SynthesisTasksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSpeechSynthesisTasksResponse
extends PollyResponse
implements ToCopyableBuilder<Builder, ListSpeechSynthesisTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSpeechSynthesisTasksResponse.getter(ListSpeechSynthesisTasksResponse::nextToken)).setter(ListSpeechSynthesisTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SynthesisTask>> SYNTHESIS_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SynthesisTasks").getter(ListSpeechSynthesisTasksResponse.getter(ListSpeechSynthesisTasksResponse::synthesisTasks)).setter(ListSpeechSynthesisTasksResponse.setter(Builder::synthesisTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SynthesisTasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SynthesisTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SYNTHESIS_TASKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSpeechSynthesisTasksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SynthesisTask> synthesisTasks;

    private ListSpeechSynthesisTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.synthesisTasks = builder.synthesisTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSynthesisTasks() {
        return this.synthesisTasks != null && !(this.synthesisTasks instanceof SdkAutoConstructList);
    }

    public final List<SynthesisTask> synthesisTasks() {
        return this.synthesisTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSynthesisTasks() ? this.synthesisTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSpeechSynthesisTasksResponse)) {
            return false;
        }
        ListSpeechSynthesisTasksResponse other = (ListSpeechSynthesisTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSynthesisTasks() == other.hasSynthesisTasks() && Objects.equals(this.synthesisTasks(), other.synthesisTasks());
    }

    public final String toString() {
        return ToString.builder((String)"ListSpeechSynthesisTasksResponse").add("NextToken", (Object)this.nextToken()).add("SynthesisTasks", this.hasSynthesisTasks() ? this.synthesisTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SynthesisTasks": {
                return Optional.ofNullable(clazz.cast(this.synthesisTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SynthesisTasks", SYNTHESIS_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSpeechSynthesisTasksResponse, T> g) {
        return obj -> g.apply((ListSpeechSynthesisTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SynthesisTask> synthesisTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSpeechSynthesisTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.synthesisTasks(model.synthesisTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SynthesisTask.Builder> getSynthesisTasks() {
            List<SynthesisTask.Builder> result = SynthesisTasksCopier.copyToBuilder(this.synthesisTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSynthesisTasks(Collection<SynthesisTask.BuilderImpl> synthesisTasks) {
            this.synthesisTasks = SynthesisTasksCopier.copyFromBuilder(synthesisTasks);
        }

        @Override
        public final Builder synthesisTasks(Collection<SynthesisTask> synthesisTasks) {
            this.synthesisTasks = SynthesisTasksCopier.copy(synthesisTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synthesisTasks(SynthesisTask ... synthesisTasks) {
            this.synthesisTasks(Arrays.asList(synthesisTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synthesisTasks(Consumer<SynthesisTask.Builder> ... synthesisTasks) {
            this.synthesisTasks(Stream.of(synthesisTasks).map(c -> (SynthesisTask)((SynthesisTask.Builder)SynthesisTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSpeechSynthesisTasksResponse build() {
            return new ListSpeechSynthesisTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PollyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSpeechSynthesisTasksResponse> {
        public Builder nextToken(String var1);

        public Builder synthesisTasks(Collection<SynthesisTask> var1);

        public Builder synthesisTasks(SynthesisTask ... var1);

        public Builder synthesisTasks(Consumer<SynthesisTask.Builder> ... var1);
    }
}

