/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Engine {
    STANDARD("standard"),
    NEURAL("neural"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Engine> VALUE_MAP;
    private final String value;

    private Engine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Engine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Engine> knownValues() {
        EnumSet<Engine> knownValues = EnumSet.allOf(Engine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Engine.class, Engine::toString);
    }
}

