/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.internal.presigner.model.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;

@SdkInternalApi
public final class SynthesizeSpeechRequestMarshaller {
    private static final SynthesizeSpeechRequestMarshaller INSTANCE = new SynthesizeSpeechRequestMarshaller();

    public SdkHttpFullRequest.Builder marshall(SynthesizeSpeechRequest synthesizeSpeechRequest) {
        SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).encodedPath("/v1/speech");
        if (synthesizeSpeechRequest.text() != null) {
            builder.putRawQueryParameter("Text", synthesizeSpeechRequest.text());
        }
        if (synthesizeSpeechRequest.textType() != null) {
            builder.putRawQueryParameter("TextType", synthesizeSpeechRequest.textTypeAsString());
        }
        if (synthesizeSpeechRequest.voiceId() != null) {
            builder.putRawQueryParameter("VoiceId", synthesizeSpeechRequest.voiceIdAsString());
        }
        if (synthesizeSpeechRequest.sampleRate() != null) {
            builder.putRawQueryParameter("SampleRate", synthesizeSpeechRequest.sampleRate());
        }
        if (synthesizeSpeechRequest.outputFormat() != null) {
            builder.putRawQueryParameter("OutputFormat", synthesizeSpeechRequest.outputFormatAsString());
        }
        if (synthesizeSpeechRequest.lexiconNames() != null) {
            builder.putRawQueryParameter("LexiconNames", synthesizeSpeechRequest.lexiconNames());
        }
        if (synthesizeSpeechRequest.speechMarkTypes() != null) {
            builder.putRawQueryParameter("SpeechMarkTypes", synthesizeSpeechRequest.speechMarkTypesAsStrings());
        }
        if (synthesizeSpeechRequest.languageCode() != null) {
            builder.putRawQueryParameter("LanguageCode", synthesizeSpeechRequest.languageCodeAsString());
        }
        if (synthesizeSpeechRequest.engine() != null) {
            builder.putRawQueryParameter("Engine", synthesizeSpeechRequest.engineAsString());
        }
        return builder;
    }

    public static SynthesizeSpeechRequestMarshaller getInstance() {
        return INSTANCE;
    }
}

