/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLexiconsResponse extends PollyResponse implements
        ToCopyableBuilder<ListLexiconsResponse.Builder, ListLexiconsResponse> {
    private static final SdkField<List<LexiconDescription>> LEXICONS_FIELD = SdkField
            .<List<LexiconDescription>> builder(MarshallingType.LIST)
            .memberName("Lexicons")
            .getter(getter(ListLexiconsResponse::lexicons))
            .setter(setter(Builder::lexicons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lexicons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LexiconDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(LexiconDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLexiconsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEXICONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LexiconDescription> lexicons;

    private final String nextToken;

    private ListLexiconsResponse(BuilderImpl builder) {
        super(builder);
        this.lexicons = builder.lexicons;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Lexicons property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLexicons() {
        return lexicons != null && !(lexicons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lexicon names and attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLexicons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of lexicon names and attributes.
     */
    public final List<LexiconDescription> lexicons() {
        return lexicons;
    }

    /**
     * <p>
     * The pagination token to use in the next request to continue the listing of lexicons. <code>NextToken</code> is
     * returned only if the response is truncated.
     * </p>
     * 
     * @return The pagination token to use in the next request to continue the listing of lexicons.
     *         <code>NextToken</code> is returned only if the response is truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLexicons() ? lexicons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLexiconsResponse)) {
            return false;
        }
        ListLexiconsResponse other = (ListLexiconsResponse) obj;
        return hasLexicons() == other.hasLexicons() && Objects.equals(lexicons(), other.lexicons())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLexiconsResponse").add("Lexicons", hasLexicons() ? lexicons() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Lexicons":
            return Optional.ofNullable(clazz.cast(lexicons()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLexiconsResponse, T> g) {
        return obj -> g.apply((ListLexiconsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PollyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLexiconsResponse> {
        /**
         * <p>
         * A list of lexicon names and attributes.
         * </p>
         * 
         * @param lexicons
         *        A list of lexicon names and attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexicons(Collection<LexiconDescription> lexicons);

        /**
         * <p>
         * A list of lexicon names and attributes.
         * </p>
         * 
         * @param lexicons
         *        A list of lexicon names and attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexicons(LexiconDescription... lexicons);

        /**
         * <p>
         * A list of lexicon names and attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LexiconDescription>.Builder} avoiding the
         * need to create one manually via {@link List<LexiconDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LexiconDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #lexicons(List<LexiconDescription>)}.
         * 
         * @param lexicons
         *        a consumer that will call methods on {@link List<LexiconDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexicons(List<LexiconDescription>)
         */
        Builder lexicons(Consumer<LexiconDescription.Builder>... lexicons);

        /**
         * <p>
         * The pagination token to use in the next request to continue the listing of lexicons. <code>NextToken</code>
         * is returned only if the response is truncated.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in the next request to continue the listing of lexicons.
         *        <code>NextToken</code> is returned only if the response is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PollyResponse.BuilderImpl implements Builder {
        private List<LexiconDescription> lexicons = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLexiconsResponse model) {
            super(model);
            lexicons(model.lexicons);
            nextToken(model.nextToken);
        }

        public final Collection<LexiconDescription.Builder> getLexicons() {
            if (lexicons instanceof SdkAutoConstructList) {
                return null;
            }
            return lexicons != null ? lexicons.stream().map(LexiconDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lexicons(Collection<LexiconDescription> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copy(lexicons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexicons(LexiconDescription... lexicons) {
            lexicons(Arrays.asList(lexicons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexicons(Consumer<LexiconDescription.Builder>... lexicons) {
            lexicons(Stream.of(lexicons).map(c -> LexiconDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLexicons(Collection<LexiconDescription.BuilderImpl> lexicons) {
            this.lexicons = LexiconDescriptionListCopier.copyFromBuilder(lexicons);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLexiconsResponse build() {
            return new ListLexiconsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
