/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LexiconAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LexiconAttributes> {
    private static final SdkField<String> ALPHABET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alphabet").getter(LexiconAttributes.getter(LexiconAttributes::alphabet)).setter(LexiconAttributes.setter(Builder::alphabet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alphabet").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(LexiconAttributes.getter(LexiconAttributes::languageCodeAsString)).setter(LexiconAttributes.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(LexiconAttributes.getter(LexiconAttributes::lastModified)).setter(LexiconAttributes.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LEXICON_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LexiconArn").getter(LexiconAttributes.getter(LexiconAttributes::lexiconArn)).setter(LexiconAttributes.setter(Builder::lexiconArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconArn").build()}).build();
    private static final SdkField<Integer> LEXEMES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LexemesCount").getter(LexiconAttributes.getter(LexiconAttributes::lexemesCount)).setter(LexiconAttributes.setter(Builder::lexemesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexemesCount").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(LexiconAttributes.getter(LexiconAttributes::size)).setter(LexiconAttributes.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALPHABET_FIELD, LANGUAGE_CODE_FIELD, LAST_MODIFIED_FIELD, LEXICON_ARN_FIELD, LEXEMES_COUNT_FIELD, SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alphabet;
    private final String languageCode;
    private final Instant lastModified;
    private final String lexiconArn;
    private final Integer lexemesCount;
    private final Integer size;

    private LexiconAttributes(BuilderImpl builder) {
        this.alphabet = builder.alphabet;
        this.languageCode = builder.languageCode;
        this.lastModified = builder.lastModified;
        this.lexiconArn = builder.lexiconArn;
        this.lexemesCount = builder.lexemesCount;
        this.size = builder.size;
    }

    public final String alphabet() {
        return this.alphabet;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String lexiconArn() {
        return this.lexiconArn;
    }

    public final Integer lexemesCount() {
        return this.lexemesCount;
    }

    public final Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alphabet());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexiconArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexemesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexiconAttributes)) {
            return false;
        }
        LexiconAttributes other = (LexiconAttributes)obj;
        return Objects.equals(this.alphabet(), other.alphabet()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lexiconArn(), other.lexiconArn()) && Objects.equals(this.lexemesCount(), other.lexemesCount()) && Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"LexiconAttributes").add("Alphabet", (Object)this.alphabet()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LastModified", (Object)this.lastModified()).add("LexiconArn", (Object)this.lexiconArn()).add("LexemesCount", (Object)this.lexemesCount()).add("Size", (Object)this.size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alphabet": {
                return Optional.ofNullable(clazz.cast(this.alphabet()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LexiconArn": {
                return Optional.ofNullable(clazz.cast(this.lexiconArn()));
            }
            case "LexemesCount": {
                return Optional.ofNullable(clazz.cast(this.lexemesCount()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LexiconAttributes, T> g) {
        return obj -> g.apply((LexiconAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alphabet;
        private String languageCode;
        private Instant lastModified;
        private String lexiconArn;
        private Integer lexemesCount;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(LexiconAttributes model) {
            this.alphabet(model.alphabet);
            this.languageCode(model.languageCode);
            this.lastModified(model.lastModified);
            this.lexiconArn(model.lexiconArn);
            this.lexemesCount(model.lexemesCount);
            this.size(model.size);
        }

        public final String getAlphabet() {
            return this.alphabet;
        }

        @Override
        public final Builder alphabet(String alphabet) {
            this.alphabet = alphabet;
            return this;
        }

        public final void setAlphabet(String alphabet) {
            this.alphabet = alphabet;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLexiconArn() {
            return this.lexiconArn;
        }

        @Override
        public final Builder lexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
            return this;
        }

        public final void setLexiconArn(String lexiconArn) {
            this.lexiconArn = lexiconArn;
        }

        public final Integer getLexemesCount() {
            return this.lexemesCount;
        }

        @Override
        public final Builder lexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
            return this;
        }

        public final void setLexemesCount(Integer lexemesCount) {
            this.lexemesCount = lexemesCount;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public LexiconAttributes build() {
            return new LexiconAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LexiconAttributes> {
        public Builder alphabet(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lastModified(Instant var1);

        public Builder lexiconArn(String var1);

        public Builder lexemesCount(Integer var1);

        public Builder size(Integer var1);
    }
}

