/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.Engine;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TaskStatus;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SynthesisTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SynthesisTask> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(SynthesisTask.getter(SynthesisTask::engineAsString)).setter(SynthesisTask.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(SynthesisTask.getter(SynthesisTask::taskId)).setter(SynthesisTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatus").getter(SynthesisTask.getter(SynthesisTask::taskStatusAsString)).setter(SynthesisTask.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()}).build();
    private static final SdkField<String> TASK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatusReason").getter(SynthesisTask.getter(SynthesisTask::taskStatusReason)).setter(SynthesisTask.setter(Builder::taskStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatusReason").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputUri").getter(SynthesisTask.getter(SynthesisTask::outputUri)).setter(SynthesisTask.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUri").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(SynthesisTask.getter(SynthesisTask::creationTime)).setter(SynthesisTask.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Integer> REQUEST_CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestCharacters").getter(SynthesisTask.getter(SynthesisTask::requestCharacters)).setter(SynthesisTask.setter(Builder::requestCharacters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestCharacters").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(SynthesisTask.getter(SynthesisTask::snsTopicArn)).setter(SynthesisTask.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<List<String>> LEXICON_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LexiconNames").getter(SynthesisTask.getter(SynthesisTask::lexiconNames)).setter(SynthesisTask.setter(Builder::lexiconNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(SynthesisTask.getter(SynthesisTask::outputFormatAsString)).setter(SynthesisTask.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleRate").getter(SynthesisTask.getter(SynthesisTask::sampleRate)).setter(SynthesisTask.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()}).build();
    private static final SdkField<List<String>> SPEECH_MARK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpeechMarkTypes").getter(SynthesisTask.getter(SynthesisTask::speechMarkTypesAsStrings)).setter(SynthesisTask.setter(Builder::speechMarkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeechMarkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextType").getter(SynthesisTask.getter(SynthesisTask::textTypeAsString)).setter(SynthesisTask.setter(Builder::textType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextType").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(SynthesisTask.getter(SynthesisTask::voiceIdAsString)).setter(SynthesisTask.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(SynthesisTask.getter(SynthesisTask::languageCodeAsString)).setter(SynthesisTask.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, TASK_ID_FIELD, TASK_STATUS_FIELD, TASK_STATUS_REASON_FIELD, OUTPUT_URI_FIELD, CREATION_TIME_FIELD, REQUEST_CHARACTERS_FIELD, SNS_TOPIC_ARN_FIELD, LEXICON_NAMES_FIELD, OUTPUT_FORMAT_FIELD, SAMPLE_RATE_FIELD, SPEECH_MARK_TYPES_FIELD, TEXT_TYPE_FIELD, VOICE_ID_FIELD, LANGUAGE_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String taskId;
    private final String taskStatus;
    private final String taskStatusReason;
    private final String outputUri;
    private final Instant creationTime;
    private final Integer requestCharacters;
    private final String snsTopicArn;
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String sampleRate;
    private final List<String> speechMarkTypes;
    private final String textType;
    private final String voiceId;
    private final String languageCode;

    private SynthesisTask(BuilderImpl builder) {
        this.engine = builder.engine;
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.taskStatusReason = builder.taskStatusReason;
        this.outputUri = builder.outputUri;
        this.creationTime = builder.creationTime;
        this.requestCharacters = builder.requestCharacters;
        this.snsTopicArn = builder.snsTopicArn;
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.sampleRate = builder.sampleRate;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
        this.languageCode = builder.languageCode;
    }

    public final Engine engine() {
        return Engine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final String taskStatusReason() {
        return this.taskStatusReason;
    }

    public final String outputUri() {
        return this.outputUri;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Integer requestCharacters() {
        return this.requestCharacters;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final boolean hasLexiconNames() {
        return this.lexiconNames != null && !(this.lexiconNames instanceof SdkAutoConstructList);
    }

    public final List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final String sampleRate() {
        return this.sampleRate;
    }

    public final List<SpeechMarkType> speechMarkTypes() {
        return SpeechMarkTypeListCopier.copyStringToEnum(this.speechMarkTypes);
    }

    public final boolean hasSpeechMarkTypes() {
        return this.speechMarkTypes != null && !(this.speechMarkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public final TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public final String textTypeAsString() {
        return this.textType;
    }

    public final VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public final String voiceIdAsString() {
        return this.voiceId;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLexiconNames() ? this.lexiconNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesisTask)) {
            return false;
        }
        SynthesisTask other = (SynthesisTask)obj;
        return Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.taskStatusReason(), other.taskStatusReason()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.requestCharacters(), other.requestCharacters()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && this.hasLexiconNames() == other.hasLexiconNames() && Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && this.hasSpeechMarkTypes() == other.hasSpeechMarkTypes() && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SynthesisTask").add("Engine", (Object)this.engineAsString()).add("TaskId", (Object)this.taskId()).add("TaskStatus", (Object)this.taskStatusAsString()).add("TaskStatusReason", (Object)this.taskStatusReason()).add("OutputUri", (Object)this.outputUri()).add("CreationTime", (Object)this.creationTime()).add("RequestCharacters", (Object)this.requestCharacters()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("LexiconNames", this.hasLexiconNames() ? this.lexiconNames() : null).add("OutputFormat", (Object)this.outputFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("SpeechMarkTypes", this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "TaskStatusReason": {
                return Optional.ofNullable(clazz.cast(this.taskStatusReason()));
            }
            case "OutputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "RequestCharacters": {
                return Optional.ofNullable(clazz.cast(this.requestCharacters()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "LexiconNames": {
                return Optional.ofNullable(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SpeechMarkTypes": {
                return Optional.ofNullable(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SynthesisTask, T> g) {
        return obj -> g.apply((SynthesisTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String taskId;
        private String taskStatus;
        private String taskStatusReason;
        private String outputUri;
        private Instant creationTime;
        private Integer requestCharacters;
        private String snsTopicArn;
        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;
        private String sampleRate;
        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();
        private String textType;
        private String voiceId;
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesisTask model) {
            this.engine(model.engine);
            this.taskId(model.taskId);
            this.taskStatus(model.taskStatus);
            this.taskStatusReason(model.taskStatusReason);
            this.outputUri(model.outputUri);
            this.creationTime(model.creationTime);
            this.requestCharacters(model.requestCharacters);
            this.snsTopicArn(model.snsTopicArn);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.sampleRate(model.sampleRate);
            this.speechMarkTypesWithStrings(model.speechMarkTypes);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
            this.languageCode(model.languageCode);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getTaskStatusReason() {
            return this.taskStatusReason;
        }

        @Override
        public final Builder taskStatusReason(String taskStatusReason) {
            this.taskStatusReason = taskStatusReason;
            return this;
        }

        public final void setTaskStatusReason(String taskStatusReason) {
            this.taskStatusReason = taskStatusReason;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Integer getRequestCharacters() {
            return this.requestCharacters;
        }

        @Override
        public final Builder requestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
            return this;
        }

        public final void setRequestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getLexiconNames() {
            if (this.lexiconNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Collection<String> getSpeechMarkTypes() {
            if (this.speechMarkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String ... speechMarkTypes) {
            this.speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType == null ? null : textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public SynthesisTask build() {
            return new SynthesisTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SynthesisTask> {
        public Builder engine(String var1);

        public Builder engine(Engine var1);

        public Builder taskId(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder taskStatusReason(String var1);

        public Builder outputUri(String var1);

        public Builder creationTime(Instant var1);

        public Builder requestCharacters(Integer var1);

        public Builder snsTopicArn(String var1);

        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder sampleRate(String var1);

        public Builder speechMarkTypesWithStrings(Collection<String> var1);

        public Builder speechMarkTypesWithStrings(String ... var1);

        public Builder speechMarkTypes(Collection<SpeechMarkType> var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);
    }
}

