/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.Engine;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LexiconNameListCopier;
import software.amazon.awssdk.services.polly.model.OutputFormat;
import software.amazon.awssdk.services.polly.model.PollyRequest;
import software.amazon.awssdk.services.polly.model.SpeechMarkType;
import software.amazon.awssdk.services.polly.model.SpeechMarkTypeListCopier;
import software.amazon.awssdk.services.polly.model.TextType;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SynthesizeSpeechRequest
extends PollyRequest
implements ToCopyableBuilder<Builder, SynthesizeSpeechRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::engineAsString)).setter(SynthesizeSpeechRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::languageCodeAsString)).setter(SynthesizeSpeechRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<List<String>> LEXICON_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LexiconNames").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::lexiconNames)).setter(SynthesizeSpeechRequest.setter(Builder::lexiconNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexiconNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputFormat").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::outputFormatAsString)).setter(SynthesizeSpeechRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()}).build();
    private static final SdkField<String> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleRate").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::sampleRate)).setter(SynthesizeSpeechRequest.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRate").build()}).build();
    private static final SdkField<List<String>> SPEECH_MARK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpeechMarkTypes").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::speechMarkTypesAsStrings)).setter(SynthesizeSpeechRequest.setter(Builder::speechMarkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeechMarkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::text)).setter(SynthesizeSpeechRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> TEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextType").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::textTypeAsString)).setter(SynthesizeSpeechRequest.setter(Builder::textType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextType").build()}).build();
    private static final SdkField<String> VOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceId").getter(SynthesizeSpeechRequest.getter(SynthesizeSpeechRequest::voiceIdAsString)).setter(SynthesizeSpeechRequest.setter(Builder::voiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, LANGUAGE_CODE_FIELD, LEXICON_NAMES_FIELD, OUTPUT_FORMAT_FIELD, SAMPLE_RATE_FIELD, SPEECH_MARK_TYPES_FIELD, TEXT_FIELD, TEXT_TYPE_FIELD, VOICE_ID_FIELD));
    private final String engine;
    private final String languageCode;
    private final List<String> lexiconNames;
    private final String outputFormat;
    private final String sampleRate;
    private final List<String> speechMarkTypes;
    private final String text;
    private final String textType;
    private final String voiceId;

    private SynthesizeSpeechRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.languageCode = builder.languageCode;
        this.lexiconNames = builder.lexiconNames;
        this.outputFormat = builder.outputFormat;
        this.sampleRate = builder.sampleRate;
        this.speechMarkTypes = builder.speechMarkTypes;
        this.text = builder.text;
        this.textType = builder.textType;
        this.voiceId = builder.voiceId;
    }

    public final Engine engine() {
        return Engine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final boolean hasLexiconNames() {
        return this.lexiconNames != null && !(this.lexiconNames instanceof SdkAutoConstructList);
    }

    public final List<String> lexiconNames() {
        return this.lexiconNames;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final String sampleRate() {
        return this.sampleRate;
    }

    public final List<SpeechMarkType> speechMarkTypes() {
        return SpeechMarkTypeListCopier.copyStringToEnum(this.speechMarkTypes);
    }

    public final boolean hasSpeechMarkTypes() {
        return this.speechMarkTypes != null && !(this.speechMarkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> speechMarkTypesAsStrings() {
        return this.speechMarkTypes;
    }

    public final String text() {
        return this.text;
    }

    public final TextType textType() {
        return TextType.fromValue(this.textType);
    }

    public final String textTypeAsString() {
        return this.textType;
    }

    public final VoiceId voiceId() {
        return VoiceId.fromValue(this.voiceId);
    }

    public final String voiceIdAsString() {
        return this.voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLexiconNames() ? this.lexiconNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceIdAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesizeSpeechRequest)) {
            return false;
        }
        SynthesizeSpeechRequest other = (SynthesizeSpeechRequest)((Object)obj);
        return Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && this.hasLexiconNames() == other.hasLexiconNames() && Objects.equals(this.lexiconNames(), other.lexiconNames()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && this.hasSpeechMarkTypes() == other.hasSpeechMarkTypes() && Objects.equals(this.speechMarkTypesAsStrings(), other.speechMarkTypesAsStrings()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.textTypeAsString(), other.textTypeAsString()) && Objects.equals(this.voiceIdAsString(), other.voiceIdAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SynthesizeSpeechRequest").add("Engine", (Object)this.engineAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LexiconNames", this.hasLexiconNames() ? this.lexiconNames() : null).add("OutputFormat", (Object)this.outputFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("SpeechMarkTypes", this.hasSpeechMarkTypes() ? this.speechMarkTypesAsStrings() : null).add("Text", (Object)this.text()).add("TextType", (Object)this.textTypeAsString()).add("VoiceId", (Object)this.voiceIdAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LexiconNames": {
                return Optional.ofNullable(clazz.cast(this.lexiconNames()));
            }
            case "OutputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SpeechMarkTypes": {
                return Optional.ofNullable(clazz.cast(this.speechMarkTypesAsStrings()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TextType": {
                return Optional.ofNullable(clazz.cast(this.textTypeAsString()));
            }
            case "VoiceId": {
                return Optional.ofNullable(clazz.cast(this.voiceIdAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SynthesizeSpeechRequest, T> g) {
        return obj -> g.apply((SynthesizeSpeechRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyRequest.BuilderImpl
    implements Builder {
        private String engine;
        private String languageCode;
        private List<String> lexiconNames = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;
        private String sampleRate;
        private List<String> speechMarkTypes = DefaultSdkAutoConstructList.getInstance();
        private String text;
        private String textType;
        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesizeSpeechRequest model) {
            super(model);
            this.engine(model.engine);
            this.languageCode(model.languageCode);
            this.lexiconNames(model.lexiconNames);
            this.outputFormat(model.outputFormat);
            this.sampleRate(model.sampleRate);
            this.speechMarkTypesWithStrings(model.speechMarkTypes);
            this.text(model.text);
            this.textType(model.textType);
            this.voiceId(model.voiceId);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(Engine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Collection<String> getLexiconNames() {
            if (this.lexiconNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lexiconNames;
        }

        @Override
        public final Builder lexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexiconNames(String ... lexiconNames) {
            this.lexiconNames(Arrays.asList(lexiconNames));
            return this;
        }

        public final void setLexiconNames(Collection<String> lexiconNames) {
            this.lexiconNames = LexiconNameListCopier.copy(lexiconNames);
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        public final String getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final Collection<String> getSpeechMarkTypes() {
            if (this.speechMarkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.speechMarkTypes;
        }

        @Override
        public final Builder speechMarkTypesWithStrings(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypesWithStrings(String ... speechMarkTypes) {
            this.speechMarkTypesWithStrings(Arrays.asList(speechMarkTypes));
            return this;
        }

        @Override
        public final Builder speechMarkTypes(Collection<SpeechMarkType> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copyEnumToString(speechMarkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder speechMarkTypes(SpeechMarkType ... speechMarkTypes) {
            this.speechMarkTypes(Arrays.asList(speechMarkTypes));
            return this;
        }

        public final void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
            this.speechMarkTypes = SpeechMarkTypeListCopier.copy(speechMarkTypes);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getTextType() {
            return this.textType;
        }

        @Override
        public final Builder textType(String textType) {
            this.textType = textType;
            return this;
        }

        @Override
        public final Builder textType(TextType textType) {
            this.textType(textType == null ? null : textType.toString());
            return this;
        }

        public final void setTextType(String textType) {
            this.textType = textType;
        }

        public final String getVoiceId() {
            return this.voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        @Override
        public final Builder voiceId(VoiceId voiceId) {
            this.voiceId(voiceId == null ? null : voiceId.toString());
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SynthesizeSpeechRequest build() {
            return new SynthesizeSpeechRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PollyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SynthesizeSpeechRequest> {
        public Builder engine(String var1);

        public Builder engine(Engine var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lexiconNames(Collection<String> var1);

        public Builder lexiconNames(String ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder sampleRate(String var1);

        public Builder speechMarkTypesWithStrings(Collection<String> var1);

        public Builder speechMarkTypesWithStrings(String ... var1);

        public Builder speechMarkTypes(Collection<SpeechMarkType> var1);

        public Builder speechMarkTypes(SpeechMarkType ... var1);

        public Builder text(String var1);

        public Builder textType(String var1);

        public Builder textType(TextType var1);

        public Builder voiceId(String var1);

        public Builder voiceId(VoiceId var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

