/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.polly.model.Engine;
import software.amazon.awssdk.services.polly.model.EngineListCopier;
import software.amazon.awssdk.services.polly.model.Gender;
import software.amazon.awssdk.services.polly.model.LanguageCode;
import software.amazon.awssdk.services.polly.model.LanguageCodeListCopier;
import software.amazon.awssdk.services.polly.model.VoiceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Voice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Voice> {
    private static final SdkField<String> GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gender").getter(Voice.getter(Voice::genderAsString)).setter(Voice.setter(Builder::gender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Voice.getter(Voice::idAsString)).setter(Voice.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(Voice.getter(Voice::languageCodeAsString)).setter(Voice.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageName").getter(Voice.getter(Voice::languageName)).setter(Voice.setter(Builder::languageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Voice.getter(Voice::name)).setter(Voice.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalLanguageCodes").getter(Voice.getter(Voice::additionalLanguageCodesAsStrings)).setter(Voice.setter(Builder::additionalLanguageCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalLanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngines").getter(Voice.getter(Voice::supportedEnginesAsStrings)).setter(Voice.setter(Builder::supportedEnginesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENDER_FIELD, ID_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_NAME_FIELD, NAME_FIELD, ADDITIONAL_LANGUAGE_CODES_FIELD, SUPPORTED_ENGINES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gender;
    private final String id;
    private final String languageCode;
    private final String languageName;
    private final String name;
    private final List<String> additionalLanguageCodes;
    private final List<String> supportedEngines;

    private Voice(BuilderImpl builder) {
        this.gender = builder.gender;
        this.id = builder.id;
        this.languageCode = builder.languageCode;
        this.languageName = builder.languageName;
        this.name = builder.name;
        this.additionalLanguageCodes = builder.additionalLanguageCodes;
        this.supportedEngines = builder.supportedEngines;
    }

    public Gender gender() {
        return Gender.fromValue(this.gender);
    }

    public String genderAsString() {
        return this.gender;
    }

    public VoiceId id() {
        return VoiceId.fromValue(this.id);
    }

    public String idAsString() {
        return this.id;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String languageName() {
        return this.languageName;
    }

    public String name() {
        return this.name;
    }

    public List<LanguageCode> additionalLanguageCodes() {
        return LanguageCodeListCopier.copyStringToEnum(this.additionalLanguageCodes);
    }

    public boolean hasAdditionalLanguageCodes() {
        return this.additionalLanguageCodes != null && !(this.additionalLanguageCodes instanceof SdkAutoConstructList);
    }

    public List<String> additionalLanguageCodesAsStrings() {
        return this.additionalLanguageCodes;
    }

    public List<Engine> supportedEngines() {
        return EngineListCopier.copyStringToEnum(this.supportedEngines);
    }

    public boolean hasSupportedEngines() {
        return this.supportedEngines != null && !(this.supportedEngines instanceof SdkAutoConstructList);
    }

    public List<String> supportedEnginesAsStrings() {
        return this.supportedEngines;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalLanguageCodesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedEnginesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Voice)) {
            return false;
        }
        Voice other = (Voice)obj;
        return Objects.equals(this.genderAsString(), other.genderAsString()) && Objects.equals(this.idAsString(), other.idAsString()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageName(), other.languageName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.additionalLanguageCodesAsStrings(), other.additionalLanguageCodesAsStrings()) && Objects.equals(this.supportedEnginesAsStrings(), other.supportedEnginesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Voice").add("Gender", (Object)this.genderAsString()).add("Id", (Object)this.idAsString()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageName", (Object)this.languageName()).add("Name", (Object)this.name()).add("AdditionalLanguageCodes", this.additionalLanguageCodesAsStrings()).add("SupportedEngines", this.supportedEnginesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gender": {
                return Optional.ofNullable(clazz.cast(this.genderAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.idAsString()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageName": {
                return Optional.ofNullable(clazz.cast(this.languageName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AdditionalLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.additionalLanguageCodesAsStrings()));
            }
            case "SupportedEngines": {
                return Optional.ofNullable(clazz.cast(this.supportedEnginesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Voice, T> g) {
        return obj -> g.apply((Voice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gender;
        private String id;
        private String languageCode;
        private String languageName;
        private String name;
        private List<String> additionalLanguageCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedEngines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Voice model) {
            this.gender(model.gender);
            this.id(model.id);
            this.languageCode(model.languageCode);
            this.languageName(model.languageName);
            this.name(model.name);
            this.additionalLanguageCodesWithStrings(model.additionalLanguageCodes);
            this.supportedEnginesWithStrings(model.supportedEngines);
        }

        public final String getGender() {
            return this.gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder id(VoiceId id) {
            this.id(id == null ? null : id.toString());
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageName() {
            return this.languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getAdditionalLanguageCodes() {
            return this.additionalLanguageCodes;
        }

        @Override
        public final Builder additionalLanguageCodesWithStrings(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodesWithStrings(String ... additionalLanguageCodes) {
            this.additionalLanguageCodesWithStrings(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        @Override
        public final Builder additionalLanguageCodes(Collection<LanguageCode> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copyEnumToString(additionalLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLanguageCodes(LanguageCode ... additionalLanguageCodes) {
            this.additionalLanguageCodes(Arrays.asList(additionalLanguageCodes));
            return this;
        }

        public final void setAdditionalLanguageCodes(Collection<String> additionalLanguageCodes) {
            this.additionalLanguageCodes = LanguageCodeListCopier.copy(additionalLanguageCodes);
        }

        public final Collection<String> getSupportedEngines() {
            return this.supportedEngines;
        }

        @Override
        public final Builder supportedEnginesWithStrings(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEnginesWithStrings(String ... supportedEngines) {
            this.supportedEnginesWithStrings(Arrays.asList(supportedEngines));
            return this;
        }

        @Override
        public final Builder supportedEngines(Collection<Engine> supportedEngines) {
            this.supportedEngines = EngineListCopier.copyEnumToString(supportedEngines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngines(Engine ... supportedEngines) {
            this.supportedEngines(Arrays.asList(supportedEngines));
            return this;
        }

        public final void setSupportedEngines(Collection<String> supportedEngines) {
            this.supportedEngines = EngineListCopier.copy(supportedEngines);
        }

        public Voice build() {
            return new Voice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Voice> {
        public Builder gender(String var1);

        public Builder gender(Gender var1);

        public Builder id(String var1);

        public Builder id(VoiceId var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageName(String var1);

        public Builder name(String var1);

        public Builder additionalLanguageCodesWithStrings(Collection<String> var1);

        public Builder additionalLanguageCodesWithStrings(String ... var1);

        public Builder additionalLanguageCodes(Collection<LanguageCode> var1);

        public Builder additionalLanguageCodes(LanguageCode ... var1);

        public Builder supportedEnginesWithStrings(Collection<String> var1);

        public Builder supportedEnginesWithStrings(String ... var1);

        public Builder supportedEngines(Collection<Engine> var1);

        public Builder supportedEngines(Engine ... var1);
    }
}

