/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SpeechMarkType {
    SENTENCE("sentence"),
    SSML("ssml"),
    VISEME("viseme"),
    WORD("word"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SpeechMarkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpeechMarkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SpeechMarkType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpeechMarkType> knownValues() {
        return Stream.of(SpeechMarkType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

