/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.polly.model.PollyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SynthesizeSpeechResponse
extends PollyResponse
implements ToCopyableBuilder<Builder, SynthesizeSpeechResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SynthesizeSpeechResponse.getter(SynthesizeSpeechResponse::contentType)).setter(SynthesizeSpeechResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<Integer> REQUEST_CHARACTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SynthesizeSpeechResponse.getter(SynthesizeSpeechResponse::requestCharacters)).setter(SynthesizeSpeechResponse.setter(Builder::requestCharacters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-RequestCharacters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, REQUEST_CHARACTERS_FIELD));
    private final String contentType;
    private final Integer requestCharacters;

    private SynthesizeSpeechResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.requestCharacters = builder.requestCharacters;
    }

    public String contentType() {
        return this.contentType;
    }

    public Integer requestCharacters() {
        return this.requestCharacters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestCharacters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesizeSpeechResponse)) {
            return false;
        }
        SynthesizeSpeechResponse other = (SynthesizeSpeechResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.requestCharacters(), other.requestCharacters());
    }

    public String toString() {
        return ToString.builder((String)"SynthesizeSpeechResponse").add("ContentType", (Object)this.contentType()).add("RequestCharacters", (Object)this.requestCharacters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "RequestCharacters": {
                return Optional.ofNullable(clazz.cast(this.requestCharacters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SynthesizeSpeechResponse, T> g) {
        return obj -> g.apply((SynthesizeSpeechResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PollyResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private Integer requestCharacters;

        private BuilderImpl() {
        }

        private BuilderImpl(SynthesizeSpeechResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.requestCharacters(model.requestCharacters);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Integer getRequestCharacters() {
            return this.requestCharacters;
        }

        @Override
        public final Builder requestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
            return this;
        }

        public final void setRequestCharacters(Integer requestCharacters) {
            this.requestCharacters = requestCharacters;
        }

        @Override
        public SynthesizeSpeechResponse build() {
            return new SynthesizeSpeechResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PollyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SynthesizeSpeechResponse> {
        public Builder contentType(String var1);

        public Builder requestCharacters(Integer var1);
    }
}

