/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.model.Lexicon;

public class LexiconUnmarshaller
implements Unmarshaller<Lexicon, JsonUnmarshallerContext> {
    private static final LexiconUnmarshaller INSTANCE = new LexiconUnmarshaller();

    public Lexicon unmarshall(JsonUnmarshallerContext context) throws Exception {
        Lexicon.Builder lexiconBuilder = Lexicon.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Content", targetDepth)) {
                    context.nextToken();
                    lexiconBuilder.content((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    lexiconBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Lexicon)lexiconBuilder.build();
    }

    public static LexiconUnmarshaller getInstance() {
        return INSTANCE;
    }
}

