/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.presign.PresignerParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.polly.PollyClient;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.presign.PollyClientPresigners;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DeleteLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.DescribeVoicesResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.GetLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.ListLexiconsResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.PutLexiconResponseUnmarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechRequestMarshaller;
import software.amazon.awssdk.services.polly.transform.SynthesizeSpeechResponseUnmarshaller;
import software.amazon.awssdk.sync.StreamingResponseHandler;

@SdkInternalApi
final class DefaultPollyClient
implements PollyClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultPollyClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public DeleteLexiconResponse deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteLexiconResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteLexiconRequest).withMarshaller((Marshaller)new DeleteLexiconRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeVoicesResponse describeVoices() throws InvalidNextTokenException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        return this.describeVoices((DescribeVoicesRequest)((Object)DescribeVoicesRequest.builder().build()));
    }

    @Override
    public DescribeVoicesResponse describeVoices(DescribeVoicesRequest describeVoicesRequest) throws InvalidNextTokenException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeVoicesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeVoicesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeVoicesRequest).withMarshaller((Marshaller)new DescribeVoicesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetLexiconResponse getLexicon(GetLexiconRequest getLexiconRequest) throws LexiconNotFoundException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetLexiconResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getLexiconRequest).withMarshaller((Marshaller)new GetLexiconRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListLexiconsResponse listLexicons() throws InvalidNextTokenException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        return this.listLexicons((ListLexiconsRequest)((Object)ListLexiconsRequest.builder().build()));
    }

    @Override
    public ListLexiconsResponse listLexicons(ListLexiconsRequest listLexiconsRequest) throws InvalidNextTokenException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListLexiconsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListLexiconsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listLexiconsRequest).withMarshaller((Marshaller)new ListLexiconsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public PutLexiconResponse putLexicon(PutLexiconRequest putLexiconRequest) throws InvalidLexiconException, UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException, MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, SdkBaseException, SdkClientException, PollyException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutLexiconResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutLexiconResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putLexiconRequest).withMarshaller((Marshaller)new PutLexiconRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public <ReturnT> ReturnT synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, StreamingResponseHandler streamingHandler) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, SdkBaseException, SdkClientException, PollyException {
        HttpResponseHandler responseHandler = this.protocolFactory.createStreamingResponseHandler((Unmarshaller)new SynthesizeSpeechResponseUnmarshaller(), streamingHandler);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)synthesizeSpeechRequest).withMarshaller((Marshaller)new SynthesizeSpeechRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(PollyException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSampleRateException").withModeledClass(InvalidSampleRateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexiconsNumberExceededException").withModeledClass(MaxLexiconsNumberExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MarksNotSupportedForFormatException").withModeledClass(MarksNotSupportedForFormatException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MaxLexemeLengthExceededException").withModeledClass(MaxLexemeLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsLanguageException").withModeledClass(UnsupportedPlsLanguageException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlsAlphabetException").withModeledClass(UnsupportedPlsAlphabetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextLengthExceededException").withModeledClass(TextLengthExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconNotFoundException").withModeledClass(LexiconNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LexiconSizeExceededException").withModeledClass(LexiconSizeExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLexiconException").withModeledClass(InvalidLexiconException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidSsmlException").withModeledClass(InvalidSsmlException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withModeledClass(ServiceFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SsmlMarksNotSupportedForTextTypeException").withModeledClass(SsmlMarksNotSupportedForTextTypeException.class)));
    }

    @Override
    public PollyClientPresigners presigners() {
        return new PollyClientPresigners(PresignerParams.builder().endpoint(this.clientParams.getEndpoint()).credentialsProvider(this.clientParams.getCredentialsProvider()).signerProvider(this.clientParams.getSignerProvider()).build());
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

