/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 logging configuration settings for the pipe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LogDestinationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<S3LogDestinationParameters.Builder, S3LogDestinationParameters> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3LogDestinationParameters::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketOwner").getter(getter(S3LogDestinationParameters::bucketOwner))
            .setter(setter(Builder::bucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketOwner").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(S3LogDestinationParameters::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(S3LogDestinationParameters::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_OWNER_FIELD, OUTPUT_FORMAT_FIELD, PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketOwner;

    private final String outputFormat;

    private final String prefix;

    private S3LogDestinationParameters(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketOwner = builder.bucketOwner;
        this.outputFormat = builder.outputFormat;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * Specifies the name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     * </p>
     * 
     * @return Specifies the name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * Specifies the Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log
     * records for the pipe.
     * </p>
     * 
     * @return Specifies the Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers
     *         the log records for the pipe.
     */
    public final String bucketOwner() {
        return bucketOwner;
    }

    /**
     * <p>
     * How EventBridge should format the log records.
     * </p>
     * <p>
     * EventBridge currently only supports <code>json</code> formatting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link S3OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return How EventBridge should format the log records.</p>
     *         <p>
     *         EventBridge currently only supports <code>json</code> formatting.
     * @see S3OutputFormat
     */
    public final S3OutputFormat outputFormat() {
        return S3OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * How EventBridge should format the log records.
     * </p>
     * <p>
     * EventBridge currently only supports <code>json</code> formatting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link S3OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return How EventBridge should format the log records.</p>
     *         <p>
     *         EventBridge currently only supports <code>json</code> formatting.
     * @see S3OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * Specifies any prefix text with which to begin Amazon S3 log object names.
     * </p>
     * <p>
     * You can use prefixes to organize the data that you store in Amazon S3 buckets. A prefix is a string of characters
     * at the beginning of the object key name. A prefix can be any length, subject to the maximum length of the object
     * key name (1,024 bytes). For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using
     * prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * 
     * @return Specifies any prefix text with which to begin Amazon S3 log object names.</p>
     *         <p>
     *         You can use prefixes to organize the data that you store in Amazon S3 buckets. A prefix is a string of
     *         characters at the beginning of the object key name. A prefix can be any length, subject to the maximum
     *         length of the object key name (1,024 bytes). For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using
     *         prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogDestinationParameters)) {
            return false;
        }
        S3LogDestinationParameters other = (S3LogDestinationParameters) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketOwner(), other.bucketOwner())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LogDestinationParameters").add("BucketName", bucketName()).add("BucketOwner", bucketOwner())
                .add("OutputFormat", outputFormatAsString()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "BucketOwner":
            return Optional.ofNullable(clazz.cast(bucketOwner()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("BucketOwner", BUCKET_OWNER_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3LogDestinationParameters, T> g) {
        return obj -> g.apply((S3LogDestinationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LogDestinationParameters> {
        /**
         * <p>
         * Specifies the name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
         * </p>
         * 
         * @param bucketName
         *        Specifies the name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * Specifies the Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the
         * log records for the pipe.
         * </p>
         * 
         * @param bucketOwner
         *        Specifies the Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers
         *        the log records for the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwner(String bucketOwner);

        /**
         * <p>
         * How EventBridge should format the log records.
         * </p>
         * <p>
         * EventBridge currently only supports <code>json</code> formatting.
         * </p>
         * 
         * @param outputFormat
         *        How EventBridge should format the log records.</p>
         *        <p>
         *        EventBridge currently only supports <code>json</code> formatting.
         * @see S3OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * How EventBridge should format the log records.
         * </p>
         * <p>
         * EventBridge currently only supports <code>json</code> formatting.
         * </p>
         * 
         * @param outputFormat
         *        How EventBridge should format the log records.</p>
         *        <p>
         *        EventBridge currently only supports <code>json</code> formatting.
         * @see S3OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3OutputFormat
         */
        Builder outputFormat(S3OutputFormat outputFormat);

        /**
         * <p>
         * Specifies any prefix text with which to begin Amazon S3 log object names.
         * </p>
         * <p>
         * You can use prefixes to organize the data that you store in Amazon S3 buckets. A prefix is a string of
         * characters at the beginning of the object key name. A prefix can be any length, subject to the maximum length
         * of the object key name (1,024 bytes). For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using
         * prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * </p>
         * 
         * @param prefix
         *        Specifies any prefix text with which to begin Amazon S3 log object names.</p>
         *        <p>
         *        You can use prefixes to organize the data that you store in Amazon S3 buckets. A prefix is a string of
         *        characters at the beginning of the object key name. A prefix can be any length, subject to the maximum
         *        length of the object key name (1,024 bytes). For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects
         *        using prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketOwner;

        private String outputFormat;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogDestinationParameters model) {
            bucketName(model.bucketName);
            bucketOwner(model.bucketOwner);
            outputFormat(model.outputFormat);
            prefix(model.prefix);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketOwner() {
            return bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(S3OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public S3LogDestinationParameters build() {
            return new S3LogDestinationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
