/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a pipe. Amazon EventBridgePipes connect event sources to targets and reduces the need for
 * specialized knowledge and integration code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pipe implements SdkPojo, Serializable, ToCopyableBuilder<Pipe.Builder, Pipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Pipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Pipe::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(Pipe::desiredStateAsString)).setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentState").getter(getter(Pipe::currentStateAsString)).setter(setter(Builder::currentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(Pipe::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Pipe::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Pipe::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Pipe::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(Pipe::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> ENRICHMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Enrichment").getter(getter(Pipe::enrichment)).setter(setter(Builder::enrichment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enrichment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESIRED_STATE_FIELD, CURRENT_STATE_FIELD, STATE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            SOURCE_FIELD, TARGET_FIELD, ENRICHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String desiredState;

    private final String currentState;

    private final String stateReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String source;

    private final String target;

    private final String enrichment;

    private Pipe(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
        this.stateReason = builder.stateReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.source = builder.source;
        this.target = builder.target;
        this.enrichment = builder.enrichment;
    }

    /**
     * <p>
     * The name of the pipe.
     * </p>
     * 
     * @return The name of the pipe.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the pipe.
     * </p>
     * 
     * @return The ARN of the pipe.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(desiredState);
    }

    /**
     * <p>
     * The state the pipe should be in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link RequestedPipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The state the pipe should be in.
     * @see RequestedPipeState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final PipeState currentState() {
        return PipeState.fromValue(currentState);
    }

    /**
     * <p>
     * The state the pipe is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link PipeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currentStateAsString}.
     * </p>
     * 
     * @return The state the pipe is in.
     * @see PipeState
     */
    public final String currentStateAsString() {
        return currentState;
    }

    /**
     * <p>
     * The reason the pipe is in its current state.
     * </p>
     * 
     * @return The reason the pipe is in its current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The time the pipe was created.
     * </p>
     * 
     * @return The time the pipe was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     *         (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The ARN of the source resource.
     * </p>
     * 
     * @return The ARN of the source resource.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The ARN of the target resource.
     * </p>
     * 
     * @return The ARN of the target resource.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The ARN of the enrichment resource.
     * </p>
     * 
     * @return The ARN of the enrichment resource.
     */
    public final String enrichment() {
        return enrichment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(enrichment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipe)) {
            return false;
        }
        Pipe other = (Pipe) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(currentStateAsString(), other.currentStateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(source(), other.source())
                && Objects.equals(target(), other.target()) && Objects.equals(enrichment(), other.enrichment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Pipe").add("Name", name()).add("Arn", arn()).add("DesiredState", desiredStateAsString())
                .add("CurrentState", currentStateAsString()).add("StateReason", stateReason())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).add("Source", source())
                .add("Target", target()).add("Enrichment", enrichment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "CurrentState":
            return Optional.ofNullable(clazz.cast(currentStateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Enrichment":
            return Optional.ofNullable(clazz.cast(enrichment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("CurrentState", CURRENT_STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("Enrichment", ENRICHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Pipe, T> g) {
        return obj -> g.apply((Pipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pipe> {
        /**
         * <p>
         * The name of the pipe.
         * </p>
         * 
         * @param name
         *        The name of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the pipe.
         * </p>
         * 
         * @param arn
         *        The ARN of the pipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The state the pipe should be in.
         * </p>
         * 
         * @param desiredState
         *        The state the pipe should be in.
         * @see RequestedPipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestedPipeState
         */
        Builder desiredState(RequestedPipeState desiredState);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(String currentState);

        /**
         * <p>
         * The state the pipe is in.
         * </p>
         * 
         * @param currentState
         *        The state the pipe is in.
         * @see PipeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipeState
         */
        Builder currentState(PipeState currentState);

        /**
         * <p>
         * The reason the pipe is in its current state.
         * </p>
         * 
         * @param stateReason
         *        The reason the pipe is in its current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The time the pipe was created.
         * </p>
         * 
         * @param creationTime
         *        The time the pipe was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
         * (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param lastModifiedTime
         *        When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
         *        (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The ARN of the source resource.
         * </p>
         * 
         * @param source
         *        The ARN of the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The ARN of the target resource.
         * </p>
         * 
         * @param target
         *        The ARN of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The ARN of the enrichment resource.
         * </p>
         * 
         * @param enrichment
         *        The ARN of the enrichment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichment(String enrichment);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String desiredState;

        private String currentState;

        private String stateReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String source;

        private String target;

        private String enrichment;

        private BuilderImpl() {
        }

        private BuilderImpl(Pipe model) {
            name(model.name);
            arn(model.arn);
            desiredState(model.desiredState);
            currentState(model.currentState);
            stateReason(model.stateReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            source(model.source);
            target(model.target);
            enrichment(model.enrichment);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(PipeState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getEnrichment() {
            return enrichment;
        }

        public final void setEnrichment(String enrichment) {
            this.enrichment = enrichment;
        }

        @Override
        public final Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        @Override
        public Pipe build() {
            return new Pipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
