/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipesResponse extends PipesResponse implements
        ToCopyableBuilder<ListPipesResponse.Builder, ListPipesResponse> {
    private static final SdkField<List<Pipe>> PIPES_FIELD = SdkField
            .<List<Pipe>> builder(MarshallingType.LIST)
            .memberName("Pipes")
            .getter(getter(ListPipesResponse::pipes))
            .setter(setter(Builder::pipes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Pipe> builder(MarshallingType.SDK_POJO)
                                            .constructor(Pipe::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PIPES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Pipe> pipes;

    private final String nextToken;

    private ListPipesResponse(BuilderImpl builder) {
        super(builder);
        this.pipes = builder.pipes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pipes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPipes() {
        return pipes != null && !(pipes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pipes returned by the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipes} method.
     * </p>
     * 
     * @return The pipes returned by the call.
     */
    public final List<Pipe> pipes() {
        return pipes;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an HTTP 400 InvalidToken error.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipes() ? pipes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipesResponse)) {
            return false;
        }
        ListPipesResponse other = (ListPipesResponse) obj;
        return hasPipes() == other.hasPipes() && Objects.equals(pipes(), other.pipes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipesResponse").add("Pipes", hasPipes() ? pipes() : null)
                .add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipes":
            return Optional.ofNullable(clazz.cast(pipes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pipes", PIPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipesResponse, T> g) {
        return obj -> g.apply((ListPipesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PipesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipesResponse> {
        /**
         * <p>
         * The pipes returned by the call.
         * </p>
         * 
         * @param pipes
         *        The pipes returned by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipes(Collection<Pipe> pipes);

        /**
         * <p>
         * The pipes returned by the call.
         * </p>
         * 
         * @param pipes
         *        The pipes returned by the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipes(Pipe... pipes);

        /**
         * <p>
         * The pipes returned by the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.Pipe.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.pipes.model.Pipe#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.pipes.model.Pipe.Builder#build()}
         * is called immediately and its result is passed to {@link #pipes(List<Pipe>)}.
         * 
         * @param pipes
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.pipes.model.Pipe.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipes(java.util.Collection<Pipe>)
         */
        Builder pipes(Consumer<Pipe.Builder>... pipes);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an HTTP 400 InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PipesResponse.BuilderImpl implements Builder {
        private List<Pipe> pipes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipesResponse model) {
            super(model);
            pipes(model.pipes);
            nextToken(model.nextToken);
        }

        public final List<Pipe.Builder> getPipes() {
            List<Pipe.Builder> result = PipeListCopier.copyToBuilder(this.pipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipes(Collection<Pipe.BuilderImpl> pipes) {
            this.pipes = PipeListCopier.copyFromBuilder(pipes);
        }

        @Override
        public final Builder pipes(Collection<Pipe> pipes) {
            this.pipes = PipeListCopier.copy(pipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipes(Pipe... pipes) {
            pipes(Arrays.asList(pipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipes(Consumer<Pipe.Builder>... pipes) {
            pipes(Stream.of(pipes).map(c -> Pipe.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPipesResponse build() {
            return new ListPipesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
