/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.Pipe;

final class PipeListCopier {
    PipeListCopier() {
    }

    static List<Pipe> copy(Collection<? extends Pipe> pipeListParam) {
        Object list;
        if (pipeListParam == null || pipeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(pipeListParam.size());
            pipeListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Pipe> copyFromBuilder(Collection<? extends Pipe.Builder> pipeListParam) {
        Object list;
        if (pipeListParam == null || pipeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(pipeListParam.size());
            pipeListParam.forEach(entry -> {
                Pipe member = entry == null ? null : (Pipe)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Pipe.Builder> copyToBuilder(Collection<? extends Pipe> pipeListParam) {
        Object list;
        if (pipeListParam == null || pipeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(pipeListParam.size());
            pipeListParam.forEach(entry -> {
                Pipe.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

