/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pipes.model.BatchArrayProperties;
import software.amazon.awssdk.services.pipes.model.BatchContainerOverrides;
import software.amazon.awssdk.services.pipes.model.BatchDependsOnCopier;
import software.amazon.awssdk.services.pipes.model.BatchJobDependency;
import software.amazon.awssdk.services.pipes.model.BatchParametersMapCopier;
import software.amazon.awssdk.services.pipes.model.BatchRetryStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeTargetBatchJobParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeTargetBatchJobParameters> {
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDefinition").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::jobDefinition)).setter(PipeTargetBatchJobParameters.setter(Builder::jobDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinition").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::jobName)).setter(PipeTargetBatchJobParameters.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<BatchArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArrayProperties").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::arrayProperties)).setter(PipeTargetBatchJobParameters.setter(Builder::arrayProperties)).constructor(BatchArrayProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayProperties").build()}).build();
    private static final SdkField<BatchRetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryStrategy").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::retryStrategy)).setter(PipeTargetBatchJobParameters.setter(Builder::retryStrategy)).constructor(BatchRetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()}).build();
    private static final SdkField<BatchContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerOverrides").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::containerOverrides)).setter(PipeTargetBatchJobParameters.setter(Builder::containerOverrides)).constructor(BatchContainerOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerOverrides").build()}).build();
    private static final SdkField<List<BatchJobDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependsOn").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::dependsOn)).setter(PipeTargetBatchJobParameters.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchJobDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(PipeTargetBatchJobParameters.getter(PipeTargetBatchJobParameters::parameters)).setter(PipeTargetBatchJobParameters.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_FIELD, JOB_NAME_FIELD, ARRAY_PROPERTIES_FIELD, RETRY_STRATEGY_FIELD, CONTAINER_OVERRIDES_FIELD, DEPENDS_ON_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobDefinition", JOB_DEFINITION_FIELD);
            this.put("JobName", JOB_NAME_FIELD);
            this.put("ArrayProperties", ARRAY_PROPERTIES_FIELD);
            this.put("RetryStrategy", RETRY_STRATEGY_FIELD);
            this.put("ContainerOverrides", CONTAINER_OVERRIDES_FIELD);
            this.put("DependsOn", DEPENDS_ON_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobDefinition;
    private final String jobName;
    private final BatchArrayProperties arrayProperties;
    private final BatchRetryStrategy retryStrategy;
    private final BatchContainerOverrides containerOverrides;
    private final List<BatchJobDependency> dependsOn;
    private final Map<String, String> parameters;

    private PipeTargetBatchJobParameters(BuilderImpl builder) {
        this.jobDefinition = builder.jobDefinition;
        this.jobName = builder.jobName;
        this.arrayProperties = builder.arrayProperties;
        this.retryStrategy = builder.retryStrategy;
        this.containerOverrides = builder.containerOverrides;
        this.dependsOn = builder.dependsOn;
        this.parameters = builder.parameters;
    }

    public final String jobDefinition() {
        return this.jobDefinition;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final BatchArrayProperties arrayProperties() {
        return this.arrayProperties;
    }

    public final BatchRetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final BatchContainerOverrides containerOverrides() {
        return this.containerOverrides;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<BatchJobDependency> dependsOn() {
        return this.dependsOn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetBatchJobParameters)) {
            return false;
        }
        PipeTargetBatchJobParameters other = (PipeTargetBatchJobParameters)obj;
        return Objects.equals(this.jobDefinition(), other.jobDefinition()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.arrayProperties(), other.arrayProperties()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.containerOverrides(), other.containerOverrides()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"PipeTargetBatchJobParameters").add("JobDefinition", (Object)this.jobDefinition()).add("JobName", (Object)this.jobName()).add("ArrayProperties", (Object)this.arrayProperties()).add("RetryStrategy", (Object)this.retryStrategy()).add("ContainerOverrides", (Object)this.containerOverrides()).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobDefinition": {
                return Optional.ofNullable(clazz.cast(this.jobDefinition()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "ArrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
            case "RetryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "ContainerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "DependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetBatchJobParameters, T> g) {
        return obj -> g.apply((PipeTargetBatchJobParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobDefinition;
        private String jobName;
        private BatchArrayProperties arrayProperties;
        private BatchRetryStrategy retryStrategy;
        private BatchContainerOverrides containerOverrides;
        private List<BatchJobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetBatchJobParameters model) {
            this.jobDefinition(model.jobDefinition);
            this.jobName(model.jobName);
            this.arrayProperties(model.arrayProperties);
            this.retryStrategy(model.retryStrategy);
            this.containerOverrides(model.containerOverrides);
            this.dependsOn(model.dependsOn);
            this.parameters(model.parameters);
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final BatchArrayProperties.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(BatchArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        public final Builder arrayProperties(BatchArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final BatchRetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(BatchRetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(BatchRetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final BatchContainerOverrides.Builder getContainerOverrides() {
            return this.containerOverrides != null ? this.containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(BatchContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        public final Builder containerOverrides(BatchContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final List<BatchJobDependency.Builder> getDependsOn() {
            List<BatchJobDependency.Builder> result = BatchDependsOnCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<BatchJobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = BatchDependsOnCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<BatchJobDependency> dependsOn) {
            this.dependsOn = BatchDependsOnCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(BatchJobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<BatchJobDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (BatchJobDependency)((BatchJobDependency.Builder)BatchJobDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = BatchParametersMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = BatchParametersMapCopier.copy(parameters);
            return this;
        }

        public PipeTargetBatchJobParameters build() {
            return new PipeTargetBatchJobParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeTargetBatchJobParameters> {
        public Builder jobDefinition(String var1);

        public Builder jobName(String var1);

        public Builder arrayProperties(BatchArrayProperties var1);

        default public Builder arrayProperties(Consumer<BatchArrayProperties.Builder> arrayProperties) {
            return this.arrayProperties((BatchArrayProperties)((BatchArrayProperties.Builder)BatchArrayProperties.builder().applyMutation(arrayProperties)).build());
        }

        public Builder retryStrategy(BatchRetryStrategy var1);

        default public Builder retryStrategy(Consumer<BatchRetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((BatchRetryStrategy)((BatchRetryStrategy.Builder)BatchRetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder containerOverrides(BatchContainerOverrides var1);

        default public Builder containerOverrides(Consumer<BatchContainerOverrides.Builder> containerOverrides) {
            return this.containerOverrides((BatchContainerOverrides)((BatchContainerOverrides.Builder)BatchContainerOverrides.builder().applyMutation(containerOverrides)).build());
        }

        public Builder dependsOn(Collection<BatchJobDependency> var1);

        public Builder dependsOn(BatchJobDependency ... var1);

        public Builder dependsOn(Consumer<BatchJobDependency.Builder> ... var1);

        public Builder parameters(Map<String, String> var1);
    }
}

