/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MQBrokerAccessCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MQBrokerAccessCredentials> {
    private static final SdkField<String> BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BasicAuth").getter(MQBrokerAccessCredentials.getter(MQBrokerAccessCredentials::basicAuth)).setter(MQBrokerAccessCredentials.setter(Builder::basicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BasicAuth", BASIC_AUTH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String basicAuth;
    private final Type type;

    private MQBrokerAccessCredentials(BuilderImpl builder) {
        this.basicAuth = builder.basicAuth;
        this.type = builder.type;
    }

    public final String basicAuth() {
        return this.basicAuth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MQBrokerAccessCredentials)) {
            return false;
        }
        MQBrokerAccessCredentials other = (MQBrokerAccessCredentials)obj;
        return Objects.equals(this.basicAuth(), other.basicAuth());
    }

    public final String toString() {
        return ToString.builder((String)"MQBrokerAccessCredentials").add("BasicAuth", (Object)this.basicAuth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BasicAuth": {
                return Optional.ofNullable(clazz.cast(this.basicAuth()));
            }
        }
        return Optional.empty();
    }

    public static MQBrokerAccessCredentials fromBasicAuth(String basicAuth) {
        return (MQBrokerAccessCredentials)MQBrokerAccessCredentials.builder().basicAuth(basicAuth).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MQBrokerAccessCredentials, T> g) {
        return obj -> g.apply((MQBrokerAccessCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BASIC_AUTH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String basicAuth;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MQBrokerAccessCredentials model) {
            this.basicAuth(model.basicAuth);
        }

        public final String getBasicAuth() {
            return this.basicAuth;
        }

        public final void setBasicAuth(String basicAuth) {
            String oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            this.handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
        }

        @Override
        public final Builder basicAuth(String basicAuth) {
            String oldValue = this.basicAuth;
            this.basicAuth = basicAuth;
            this.handleUnionValueChange(Type.BASIC_AUTH, oldValue, this.basicAuth);
            return this;
        }

        public MQBrokerAccessCredentials build() {
            return new MQBrokerAccessCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MQBrokerAccessCredentials> {
        public Builder basicAuth(String var1);
    }
}

