/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeEnrichmentParameters;
import software.amazon.awssdk.services.pipes.model.PipeLogConfigurationParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetParameters;
import software.amazon.awssdk.services.pipes.model.PipesRequest;
import software.amazon.awssdk.services.pipes.model.RequestedPipeState;
import software.amazon.awssdk.services.pipes.model.UpdatePipeSourceParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeRequest
extends PipesRequest
implements ToCopyableBuilder<Builder, UpdatePipeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePipeRequest.getter(UpdatePipeRequest::name)).setter(UpdatePipeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePipeRequest.getter(UpdatePipeRequest::description)).setter(UpdatePipeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(UpdatePipeRequest.getter(UpdatePipeRequest::desiredStateAsString)).setter(UpdatePipeRequest.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<UpdatePipeSourceParameters> SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceParameters").getter(UpdatePipeRequest.getter(UpdatePipeRequest::sourceParameters)).setter(UpdatePipeRequest.setter(Builder::sourceParameters)).constructor(UpdatePipeSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameters").build()}).build();
    private static final SdkField<String> ENRICHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Enrichment").getter(UpdatePipeRequest.getter(UpdatePipeRequest::enrichment)).setter(UpdatePipeRequest.setter(Builder::enrichment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enrichment").build()}).build();
    private static final SdkField<PipeEnrichmentParameters> ENRICHMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnrichmentParameters").getter(UpdatePipeRequest.getter(UpdatePipeRequest::enrichmentParameters)).setter(UpdatePipeRequest.setter(Builder::enrichmentParameters)).constructor(PipeEnrichmentParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrichmentParameters").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(UpdatePipeRequest.getter(UpdatePipeRequest::target)).setter(UpdatePipeRequest.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<PipeTargetParameters> TARGET_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetParameters").getter(UpdatePipeRequest.getter(UpdatePipeRequest::targetParameters)).setter(UpdatePipeRequest.setter(Builder::targetParameters)).constructor(PipeTargetParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameters").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdatePipeRequest.getter(UpdatePipeRequest::roleArn)).setter(UpdatePipeRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<PipeLogConfigurationParameters> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(UpdatePipeRequest.getter(UpdatePipeRequest::logConfiguration)).setter(UpdatePipeRequest.setter(Builder::logConfiguration)).constructor(PipeLogConfigurationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(UpdatePipeRequest.getter(UpdatePipeRequest::kmsKeyIdentifier)).setter(UpdatePipeRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DESIRED_STATE_FIELD, SOURCE_PARAMETERS_FIELD, ENRICHMENT_FIELD, ENRICHMENT_PARAMETERS_FIELD, TARGET_FIELD, TARGET_PARAMETERS_FIELD, ROLE_ARN_FIELD, LOG_CONFIGURATION_FIELD, KMS_KEY_IDENTIFIER_FIELD));
    private final String name;
    private final String description;
    private final String desiredState;
    private final UpdatePipeSourceParameters sourceParameters;
    private final String enrichment;
    private final PipeEnrichmentParameters enrichmentParameters;
    private final String target;
    private final PipeTargetParameters targetParameters;
    private final String roleArn;
    private final PipeLogConfigurationParameters logConfiguration;
    private final String kmsKeyIdentifier;

    private UpdatePipeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.desiredState = builder.desiredState;
        this.sourceParameters = builder.sourceParameters;
        this.enrichment = builder.enrichment;
        this.enrichmentParameters = builder.enrichmentParameters;
        this.target = builder.target;
        this.targetParameters = builder.targetParameters;
        this.roleArn = builder.roleArn;
        this.logConfiguration = builder.logConfiguration;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final RequestedPipeState desiredState() {
        return RequestedPipeState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final UpdatePipeSourceParameters sourceParameters() {
        return this.sourceParameters;
    }

    public final String enrichment() {
        return this.enrichment;
    }

    public final PipeEnrichmentParameters enrichmentParameters() {
        return this.enrichmentParameters;
    }

    public final String target() {
        return this.target;
    }

    public final PipeTargetParameters targetParameters() {
        return this.targetParameters;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final PipeLogConfigurationParameters logConfiguration() {
        return this.logConfiguration;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrichment());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrichmentParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeRequest)) {
            return false;
        }
        UpdatePipeRequest other = (UpdatePipeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.sourceParameters(), other.sourceParameters()) && Objects.equals(this.enrichment(), other.enrichment()) && Objects.equals(this.enrichmentParameters(), other.enrichmentParameters()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.targetParameters(), other.targetParameters()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeRequest").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DesiredState", (Object)this.desiredStateAsString()).add("SourceParameters", (Object)this.sourceParameters()).add("Enrichment", (Object)this.enrichment()).add("EnrichmentParameters", (Object)this.enrichmentParameters()).add("Target", (Object)this.target()).add("TargetParameters", (Object)this.targetParameters()).add("RoleArn", (Object)this.roleArn()).add("LogConfiguration", (Object)this.logConfiguration()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "SourceParameters": {
                return Optional.ofNullable(clazz.cast(this.sourceParameters()));
            }
            case "Enrichment": {
                return Optional.ofNullable(clazz.cast(this.enrichment()));
            }
            case "EnrichmentParameters": {
                return Optional.ofNullable(clazz.cast(this.enrichmentParameters()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "TargetParameters": {
                return Optional.ofNullable(clazz.cast(this.targetParameters()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeRequest, T> g) {
        return obj -> g.apply((UpdatePipeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String desiredState;
        private UpdatePipeSourceParameters sourceParameters;
        private String enrichment;
        private PipeEnrichmentParameters enrichmentParameters;
        private String target;
        private PipeTargetParameters targetParameters;
        private String roleArn;
        private PipeLogConfigurationParameters logConfiguration;
        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.desiredState(model.desiredState);
            this.sourceParameters(model.sourceParameters);
            this.enrichment(model.enrichment);
            this.enrichmentParameters(model.enrichmentParameters);
            this.target(model.target);
            this.targetParameters(model.targetParameters);
            this.roleArn(model.roleArn);
            this.logConfiguration(model.logConfiguration);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(RequestedPipeState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final UpdatePipeSourceParameters.Builder getSourceParameters() {
            return this.sourceParameters != null ? this.sourceParameters.toBuilder() : null;
        }

        public final void setSourceParameters(UpdatePipeSourceParameters.BuilderImpl sourceParameters) {
            this.sourceParameters = sourceParameters != null ? sourceParameters.build() : null;
        }

        @Override
        public final Builder sourceParameters(UpdatePipeSourceParameters sourceParameters) {
            this.sourceParameters = sourceParameters;
            return this;
        }

        public final String getEnrichment() {
            return this.enrichment;
        }

        public final void setEnrichment(String enrichment) {
            this.enrichment = enrichment;
        }

        @Override
        public final Builder enrichment(String enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public final PipeEnrichmentParameters.Builder getEnrichmentParameters() {
            return this.enrichmentParameters != null ? this.enrichmentParameters.toBuilder() : null;
        }

        public final void setEnrichmentParameters(PipeEnrichmentParameters.BuilderImpl enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters != null ? enrichmentParameters.build() : null;
        }

        @Override
        public final Builder enrichmentParameters(PipeEnrichmentParameters enrichmentParameters) {
            this.enrichmentParameters = enrichmentParameters;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final PipeTargetParameters.Builder getTargetParameters() {
            return this.targetParameters != null ? this.targetParameters.toBuilder() : null;
        }

        public final void setTargetParameters(PipeTargetParameters.BuilderImpl targetParameters) {
            this.targetParameters = targetParameters != null ? targetParameters.build() : null;
        }

        @Override
        public final Builder targetParameters(PipeTargetParameters targetParameters) {
            this.targetParameters = targetParameters;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final PipeLogConfigurationParameters.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(PipeLogConfigurationParameters.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(PipeLogConfigurationParameters logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipeRequest build() {
            return new UpdatePipeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PipesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder desiredState(String var1);

        public Builder desiredState(RequestedPipeState var1);

        public Builder sourceParameters(UpdatePipeSourceParameters var1);

        default public Builder sourceParameters(Consumer<UpdatePipeSourceParameters.Builder> sourceParameters) {
            return this.sourceParameters((UpdatePipeSourceParameters)((UpdatePipeSourceParameters.Builder)UpdatePipeSourceParameters.builder().applyMutation(sourceParameters)).build());
        }

        public Builder enrichment(String var1);

        public Builder enrichmentParameters(PipeEnrichmentParameters var1);

        default public Builder enrichmentParameters(Consumer<PipeEnrichmentParameters.Builder> enrichmentParameters) {
            return this.enrichmentParameters((PipeEnrichmentParameters)((PipeEnrichmentParameters.Builder)PipeEnrichmentParameters.builder().applyMutation(enrichmentParameters)).build());
        }

        public Builder target(String var1);

        public Builder targetParameters(PipeTargetParameters var1);

        default public Builder targetParameters(Consumer<PipeTargetParameters.Builder> targetParameters) {
            return this.targetParameters((PipeTargetParameters)((PipeTargetParameters.Builder)PipeTargetParameters.builder().applyMutation(targetParameters)).build());
        }

        public Builder roleArn(String var1);

        public Builder logConfiguration(PipeLogConfigurationParameters var1);

        default public Builder logConfiguration(Consumer<PipeLogConfigurationParameters.Builder> logConfiguration) {
            return this.logConfiguration((PipeLogConfigurationParameters)((PipeLogConfigurationParameters.Builder)PipeLogConfigurationParameters.builder().applyMutation(logConfiguration)).build());
        }

        public Builder kmsKeyIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

