/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.FilterCriteria;
import software.amazon.awssdk.services.pipes.model.PipeSourceActiveMQBrokerParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceDynamoDBStreamParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceKinesisStreamParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceManagedStreamingKafkaParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceRabbitMQBrokerParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceSelfManagedKafkaParameters;
import software.amazon.awssdk.services.pipes.model.PipeSourceSqsQueueParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeSourceParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeSourceParameters> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(PipeSourceParameters.getter(PipeSourceParameters::filterCriteria)).setter(PipeSourceParameters.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<PipeSourceKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::kinesisStreamParameters)).setter(PipeSourceParameters.setter(Builder::kinesisStreamParameters)).constructor(PipeSourceKinesisStreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build()}).build();
    private static final SdkField<PipeSourceDynamoDBStreamParameters> DYNAMO_DB_STREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamoDBStreamParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::dynamoDBStreamParameters)).setter(PipeSourceParameters.setter(Builder::dynamoDBStreamParameters)).constructor(PipeSourceDynamoDBStreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDBStreamParameters").build()}).build();
    private static final SdkField<PipeSourceSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqsQueueParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::sqsQueueParameters)).setter(PipeSourceParameters.setter(Builder::sqsQueueParameters)).constructor(PipeSourceSqsQueueParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build()}).build();
    private static final SdkField<PipeSourceActiveMQBrokerParameters> ACTIVE_MQ_BROKER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveMQBrokerParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::activeMQBrokerParameters)).setter(PipeSourceParameters.setter(Builder::activeMQBrokerParameters)).constructor(PipeSourceActiveMQBrokerParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveMQBrokerParameters").build()}).build();
    private static final SdkField<PipeSourceRabbitMQBrokerParameters> RABBIT_MQ_BROKER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RabbitMQBrokerParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::rabbitMQBrokerParameters)).setter(PipeSourceParameters.setter(Builder::rabbitMQBrokerParameters)).constructor(PipeSourceRabbitMQBrokerParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RabbitMQBrokerParameters").build()}).build();
    private static final SdkField<PipeSourceManagedStreamingKafkaParameters> MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedStreamingKafkaParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::managedStreamingKafkaParameters)).setter(PipeSourceParameters.setter(Builder::managedStreamingKafkaParameters)).constructor(PipeSourceManagedStreamingKafkaParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStreamingKafkaParameters").build()}).build();
    private static final SdkField<PipeSourceSelfManagedKafkaParameters> SELF_MANAGED_KAFKA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedKafkaParameters").getter(PipeSourceParameters.getter(PipeSourceParameters::selfManagedKafkaParameters)).setter(PipeSourceParameters.setter(Builder::selfManagedKafkaParameters)).constructor(PipeSourceSelfManagedKafkaParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, KINESIS_STREAM_PARAMETERS_FIELD, DYNAMO_DB_STREAM_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD, ACTIVE_MQ_BROKER_PARAMETERS_FIELD, RABBIT_MQ_BROKER_PARAMETERS_FIELD, MANAGED_STREAMING_KAFKA_PARAMETERS_FIELD, SELF_MANAGED_KAFKA_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FilterCriteria filterCriteria;
    private final PipeSourceKinesisStreamParameters kinesisStreamParameters;
    private final PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;
    private final PipeSourceSqsQueueParameters sqsQueueParameters;
    private final PipeSourceActiveMQBrokerParameters activeMQBrokerParameters;
    private final PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;
    private final PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;
    private final PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

    private PipeSourceParameters(BuilderImpl builder) {
        this.filterCriteria = builder.filterCriteria;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.dynamoDBStreamParameters = builder.dynamoDBStreamParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.activeMQBrokerParameters = builder.activeMQBrokerParameters;
        this.rabbitMQBrokerParameters = builder.rabbitMQBrokerParameters;
        this.managedStreamingKafkaParameters = builder.managedStreamingKafkaParameters;
        this.selfManagedKafkaParameters = builder.selfManagedKafkaParameters;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final PipeSourceKinesisStreamParameters kinesisStreamParameters() {
        return this.kinesisStreamParameters;
    }

    public final PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters() {
        return this.dynamoDBStreamParameters;
    }

    public final PipeSourceSqsQueueParameters sqsQueueParameters() {
        return this.sqsQueueParameters;
    }

    public final PipeSourceActiveMQBrokerParameters activeMQBrokerParameters() {
        return this.activeMQBrokerParameters;
    }

    public final PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters() {
        return this.rabbitMQBrokerParameters;
    }

    public final PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters() {
        return this.managedStreamingKafkaParameters;
    }

    public final PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters() {
        return this.selfManagedKafkaParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.rabbitMQBrokerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedStreamingKafkaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedKafkaParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceParameters)) {
            return false;
        }
        PipeSourceParameters other = (PipeSourceParameters)obj;
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.kinesisStreamParameters(), other.kinesisStreamParameters()) && Objects.equals(this.dynamoDBStreamParameters(), other.dynamoDBStreamParameters()) && Objects.equals(this.sqsQueueParameters(), other.sqsQueueParameters()) && Objects.equals(this.activeMQBrokerParameters(), other.activeMQBrokerParameters()) && Objects.equals(this.rabbitMQBrokerParameters(), other.rabbitMQBrokerParameters()) && Objects.equals(this.managedStreamingKafkaParameters(), other.managedStreamingKafkaParameters()) && Objects.equals(this.selfManagedKafkaParameters(), other.selfManagedKafkaParameters());
    }

    public final String toString() {
        return ToString.builder((String)"PipeSourceParameters").add("FilterCriteria", (Object)this.filterCriteria()).add("KinesisStreamParameters", (Object)this.kinesisStreamParameters()).add("DynamoDBStreamParameters", (Object)this.dynamoDBStreamParameters()).add("SqsQueueParameters", (Object)this.sqsQueueParameters()).add("ActiveMQBrokerParameters", (Object)this.activeMQBrokerParameters()).add("RabbitMQBrokerParameters", (Object)this.rabbitMQBrokerParameters()).add("ManagedStreamingKafkaParameters", (Object)this.managedStreamingKafkaParameters()).add("SelfManagedKafkaParameters", (Object)this.selfManagedKafkaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "KinesisStreamParameters": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamParameters()));
            }
            case "DynamoDBStreamParameters": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBStreamParameters()));
            }
            case "SqsQueueParameters": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueParameters()));
            }
            case "ActiveMQBrokerParameters": {
                return Optional.ofNullable(clazz.cast(this.activeMQBrokerParameters()));
            }
            case "RabbitMQBrokerParameters": {
                return Optional.ofNullable(clazz.cast(this.rabbitMQBrokerParameters()));
            }
            case "ManagedStreamingKafkaParameters": {
                return Optional.ofNullable(clazz.cast(this.managedStreamingKafkaParameters()));
            }
            case "SelfManagedKafkaParameters": {
                return Optional.ofNullable(clazz.cast(this.selfManagedKafkaParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceParameters, T> g) {
        return obj -> g.apply((PipeSourceParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FilterCriteria filterCriteria;
        private PipeSourceKinesisStreamParameters kinesisStreamParameters;
        private PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters;
        private PipeSourceSqsQueueParameters sqsQueueParameters;
        private PipeSourceActiveMQBrokerParameters activeMQBrokerParameters;
        private PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters;
        private PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters;
        private PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceParameters model) {
            this.filterCriteria(model.filterCriteria);
            this.kinesisStreamParameters(model.kinesisStreamParameters);
            this.dynamoDBStreamParameters(model.dynamoDBStreamParameters);
            this.sqsQueueParameters(model.sqsQueueParameters);
            this.activeMQBrokerParameters(model.activeMQBrokerParameters);
            this.rabbitMQBrokerParameters(model.rabbitMQBrokerParameters);
            this.managedStreamingKafkaParameters(model.managedStreamingKafkaParameters);
            this.selfManagedKafkaParameters(model.selfManagedKafkaParameters);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final PipeSourceKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return this.kinesisStreamParameters != null ? this.kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(PipeSourceKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(PipeSourceKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final PipeSourceDynamoDBStreamParameters.Builder getDynamoDBStreamParameters() {
            return this.dynamoDBStreamParameters != null ? this.dynamoDBStreamParameters.toBuilder() : null;
        }

        public final void setDynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters.BuilderImpl dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters != null ? dynamoDBStreamParameters.build() : null;
        }

        @Override
        public final Builder dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters dynamoDBStreamParameters) {
            this.dynamoDBStreamParameters = dynamoDBStreamParameters;
            return this;
        }

        public final PipeSourceSqsQueueParameters.Builder getSqsQueueParameters() {
            return this.sqsQueueParameters != null ? this.sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(PipeSourceSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(PipeSourceSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final PipeSourceActiveMQBrokerParameters.Builder getActiveMQBrokerParameters() {
            return this.activeMQBrokerParameters != null ? this.activeMQBrokerParameters.toBuilder() : null;
        }

        public final void setActiveMQBrokerParameters(PipeSourceActiveMQBrokerParameters.BuilderImpl activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters != null ? activeMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters activeMQBrokerParameters) {
            this.activeMQBrokerParameters = activeMQBrokerParameters;
            return this;
        }

        public final PipeSourceRabbitMQBrokerParameters.Builder getRabbitMQBrokerParameters() {
            return this.rabbitMQBrokerParameters != null ? this.rabbitMQBrokerParameters.toBuilder() : null;
        }

        public final void setRabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters.BuilderImpl rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters != null ? rabbitMQBrokerParameters.build() : null;
        }

        @Override
        public final Builder rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters rabbitMQBrokerParameters) {
            this.rabbitMQBrokerParameters = rabbitMQBrokerParameters;
            return this;
        }

        public final PipeSourceManagedStreamingKafkaParameters.Builder getManagedStreamingKafkaParameters() {
            return this.managedStreamingKafkaParameters != null ? this.managedStreamingKafkaParameters.toBuilder() : null;
        }

        public final void setManagedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters.BuilderImpl managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters != null ? managedStreamingKafkaParameters.build() : null;
        }

        @Override
        public final Builder managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters managedStreamingKafkaParameters) {
            this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
            return this;
        }

        public final PipeSourceSelfManagedKafkaParameters.Builder getSelfManagedKafkaParameters() {
            return this.selfManagedKafkaParameters != null ? this.selfManagedKafkaParameters.toBuilder() : null;
        }

        public final void setSelfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters.BuilderImpl selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters != null ? selfManagedKafkaParameters.build() : null;
        }

        @Override
        public final Builder selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters selfManagedKafkaParameters) {
            this.selfManagedKafkaParameters = selfManagedKafkaParameters;
            return this;
        }

        public PipeSourceParameters build() {
            return new PipeSourceParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeSourceParameters> {
        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder kinesisStreamParameters(PipeSourceKinesisStreamParameters var1);

        default public Builder kinesisStreamParameters(Consumer<PipeSourceKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return this.kinesisStreamParameters((PipeSourceKinesisStreamParameters)((PipeSourceKinesisStreamParameters.Builder)PipeSourceKinesisStreamParameters.builder().applyMutation(kinesisStreamParameters)).build());
        }

        public Builder dynamoDBStreamParameters(PipeSourceDynamoDBStreamParameters var1);

        default public Builder dynamoDBStreamParameters(Consumer<PipeSourceDynamoDBStreamParameters.Builder> dynamoDBStreamParameters) {
            return this.dynamoDBStreamParameters((PipeSourceDynamoDBStreamParameters)((PipeSourceDynamoDBStreamParameters.Builder)PipeSourceDynamoDBStreamParameters.builder().applyMutation(dynamoDBStreamParameters)).build());
        }

        public Builder sqsQueueParameters(PipeSourceSqsQueueParameters var1);

        default public Builder sqsQueueParameters(Consumer<PipeSourceSqsQueueParameters.Builder> sqsQueueParameters) {
            return this.sqsQueueParameters((PipeSourceSqsQueueParameters)((PipeSourceSqsQueueParameters.Builder)PipeSourceSqsQueueParameters.builder().applyMutation(sqsQueueParameters)).build());
        }

        public Builder activeMQBrokerParameters(PipeSourceActiveMQBrokerParameters var1);

        default public Builder activeMQBrokerParameters(Consumer<PipeSourceActiveMQBrokerParameters.Builder> activeMQBrokerParameters) {
            return this.activeMQBrokerParameters((PipeSourceActiveMQBrokerParameters)((PipeSourceActiveMQBrokerParameters.Builder)PipeSourceActiveMQBrokerParameters.builder().applyMutation(activeMQBrokerParameters)).build());
        }

        public Builder rabbitMQBrokerParameters(PipeSourceRabbitMQBrokerParameters var1);

        default public Builder rabbitMQBrokerParameters(Consumer<PipeSourceRabbitMQBrokerParameters.Builder> rabbitMQBrokerParameters) {
            return this.rabbitMQBrokerParameters((PipeSourceRabbitMQBrokerParameters)((PipeSourceRabbitMQBrokerParameters.Builder)PipeSourceRabbitMQBrokerParameters.builder().applyMutation(rabbitMQBrokerParameters)).build());
        }

        public Builder managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParameters var1);

        default public Builder managedStreamingKafkaParameters(Consumer<PipeSourceManagedStreamingKafkaParameters.Builder> managedStreamingKafkaParameters) {
            return this.managedStreamingKafkaParameters((PipeSourceManagedStreamingKafkaParameters)((PipeSourceManagedStreamingKafkaParameters.Builder)PipeSourceManagedStreamingKafkaParameters.builder().applyMutation(managedStreamingKafkaParameters)).build());
        }

        public Builder selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParameters var1);

        default public Builder selfManagedKafkaParameters(Consumer<PipeSourceSelfManagedKafkaParameters.Builder> selfManagedKafkaParameters) {
            return this.selfManagedKafkaParameters((PipeSourceSelfManagedKafkaParameters)((PipeSourceSelfManagedKafkaParameters.Builder)PipeSourceSelfManagedKafkaParameters.builder().applyMutation(selfManagedKafkaParameters)).build());
        }
    }
}

