/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariable;
import software.amazon.awssdk.services.pipes.model.BatchEnvironmentVariableListCopier;
import software.amazon.awssdk.services.pipes.model.BatchResourceRequirement;
import software.amazon.awssdk.services.pipes.model.BatchResourceRequirementsListCopier;
import software.amazon.awssdk.services.pipes.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchContainerOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchContainerOverrides> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Command").getter(BatchContainerOverrides.getter(BatchContainerOverrides::command)).setter(BatchContainerOverrides.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchEnvironmentVariable>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Environment").getter(BatchContainerOverrides.getter(BatchContainerOverrides::environment)).setter(BatchContainerOverrides.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchEnvironmentVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(BatchContainerOverrides.getter(BatchContainerOverrides::instanceType)).setter(BatchContainerOverrides.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<List<BatchResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceRequirements").getter(BatchContainerOverrides.getter(BatchContainerOverrides::resourceRequirements)).setter(BatchContainerOverrides.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, ENVIRONMENT_FIELD, INSTANCE_TYPE_FIELD, RESOURCE_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> command;
    private final List<BatchEnvironmentVariable> environment;
    private final String instanceType;
    private final List<BatchResourceRequirement> resourceRequirements;

    private BatchContainerOverrides(BuilderImpl builder) {
        this.command = builder.command;
        this.environment = builder.environment;
        this.instanceType = builder.instanceType;
        this.resourceRequirements = builder.resourceRequirements;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<BatchEnvironmentVariable> environment() {
        return this.environment;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<BatchResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchContainerOverrides)) {
            return false;
        }
        BatchContainerOverrides other = (BatchContainerOverrides)obj;
        return this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"BatchContainerOverrides").add("Command", this.hasCommand() ? this.command() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("InstanceType", (Object)this.instanceType()).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "ResourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchContainerOverrides, T> g) {
        return obj -> g.apply((BatchContainerOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<BatchEnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private List<BatchResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchContainerOverrides model) {
            this.command(model.command);
            this.environment(model.environment);
            this.instanceType(model.instanceType);
            this.resourceRequirements(model.resourceRequirements);
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final List<BatchEnvironmentVariable.Builder> getEnvironment() {
            List<BatchEnvironmentVariable.Builder> result = BatchEnvironmentVariableListCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<BatchEnvironmentVariable.BuilderImpl> environment) {
            this.environment = BatchEnvironmentVariableListCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<BatchEnvironmentVariable> environment) {
            this.environment = BatchEnvironmentVariableListCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(BatchEnvironmentVariable ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<BatchEnvironmentVariable.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (BatchEnvironmentVariable)((BatchEnvironmentVariable.Builder)BatchEnvironmentVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final List<BatchResourceRequirement.Builder> getResourceRequirements() {
            List<BatchResourceRequirement.Builder> result = BatchResourceRequirementsListCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<BatchResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = BatchResourceRequirementsListCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<BatchResourceRequirement> resourceRequirements) {
            this.resourceRequirements = BatchResourceRequirementsListCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(BatchResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<BatchResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (BatchResourceRequirement)((BatchResourceRequirement.Builder)BatchResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchContainerOverrides build() {
            return new BatchContainerOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchContainerOverrides> {
        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder environment(Collection<BatchEnvironmentVariable> var1);

        public Builder environment(BatchEnvironmentVariable ... var1);

        public Builder environment(Consumer<BatchEnvironmentVariable.Builder> ... var1);

        public Builder instanceType(String var1);

        public Builder resourceRequirements(Collection<BatchResourceRequirement> var1);

        public Builder resourceRequirements(BatchResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<BatchResourceRequirement.Builder> ... var1);
    }
}

