/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PipeState {
    RUNNING("RUNNING"),
    STOPPED("STOPPED"),
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    STARTING("STARTING"),
    STOPPING("STOPPING"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    START_FAILED("START_FAILED"),
    STOP_FAILED("STOP_FAILED"),
    DELETE_FAILED("DELETE_FAILED"),
    CREATE_ROLLBACK_FAILED("CREATE_ROLLBACK_FAILED"),
    DELETE_ROLLBACK_FAILED("DELETE_ROLLBACK_FAILED"),
    UPDATE_ROLLBACK_FAILED("UPDATE_ROLLBACK_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PipeState> VALUE_MAP;
    private final String value;

    private PipeState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PipeState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PipeState> knownValues() {
        EnumSet<PipeState> knownValues = EnumSet.allOf(PipeState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PipeState.class, PipeState::toString);
    }
}

