/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pipes.PipesAsyncClient;
import software.amazon.awssdk.services.pipes.model.ListPipesRequest;
import software.amazon.awssdk.services.pipes.model.ListPipesResponse;
import software.amazon.awssdk.services.pipes.model.Pipe;

public class ListPipesPublisher
implements SdkPublisher<ListPipesResponse> {
    private final PipesAsyncClient client;
    private final ListPipesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipesPublisher(PipesAsyncClient client, ListPipesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipesPublisher(PipesAsyncClient client, ListPipesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Pipe> pipes() {
        Function<ListPipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipes() != null) {
                return response.pipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipesResponseFetcher
    implements AsyncPageFetcher<ListPipesResponse> {
        private ListPipesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipesResponse> nextPage(ListPipesResponse previousPage) {
            if (previousPage == null) {
                return ListPipesPublisher.this.client.listPipes(ListPipesPublisher.this.firstRequest);
            }
            return ListPipesPublisher.this.client.listPipes((ListPipesRequest)((Object)ListPipesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

