/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for using an MSK stream as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipeSourceManagedStreamingKafkaParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<PipeSourceManagedStreamingKafkaParameters.Builder, PipeSourceManagedStreamingKafkaParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(PipeSourceManagedStreamingKafkaParameters::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerGroupID").getter(getter(PipeSourceManagedStreamingKafkaParameters::consumerGroupID))
            .setter(setter(Builder::consumerGroupID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupID").build()).build();

    private static final SdkField<MSKAccessCredentials> CREDENTIALS_FIELD = SdkField
            .<MSKAccessCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(PipeSourceManagedStreamingKafkaParameters::credentials)).setter(setter(Builder::credentials))
            .constructor(MSKAccessCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(PipeSourceManagedStreamingKafkaParameters::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingPosition").getter(getter(PipeSourceManagedStreamingKafkaParameters::startingPositionAsString))
            .setter(setter(Builder::startingPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(PipeSourceManagedStreamingKafkaParameters::topicName))
            .setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD,
            CONSUMER_GROUP_ID_FIELD, CREDENTIALS_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, STARTING_POSITION_FIELD,
            TOPIC_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer batchSize;

    private final String consumerGroupID;

    private final MSKAccessCredentials credentials;

    private final Integer maximumBatchingWindowInSeconds;

    private final String startingPosition;

    private final String topicName;

    private PipeSourceManagedStreamingKafkaParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.consumerGroupID = builder.consumerGroupID;
        this.credentials = builder.credentials;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.startingPosition = builder.startingPosition;
        this.topicName = builder.topicName;
    }

    /**
     * <p>
     * The maximum number of records to include in each batch.
     * </p>
     * 
     * @return The maximum number of records to include in each batch.
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The name of the destination queue to consume.
     * </p>
     * 
     * @return The name of the destination queue to consume.
     */
    public final String consumerGroupID() {
        return consumerGroupID;
    }

    /**
     * <p>
     * The credentials needed to access the resource.
     * </p>
     * 
     * @return The credentials needed to access the resource.
     */
    public final MSKAccessCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The maximum length of a time to wait for events.
     * </p>
     * 
     * @return The maximum length of a time to wait for events.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * (Streams only) The position in a stream from which to start reading.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link MSKStartPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return (Streams only) The position in a stream from which to start reading.
     * @see MSKStartPosition
     */
    public final MSKStartPosition startingPosition() {
        return MSKStartPosition.fromValue(startingPosition);
    }

    /**
     * <p>
     * (Streams only) The position in a stream from which to start reading.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link MSKStartPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return (Streams only) The position in a stream from which to start reading.
     * @see MSKStartPosition
     */
    public final String startingPositionAsString() {
        return startingPosition;
    }

    /**
     * <p>
     * The name of the topic that the pipe will read from.
     * </p>
     * 
     * @return The name of the topic that the pipe will read from.
     */
    public final String topicName() {
        return topicName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupID());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeSourceManagedStreamingKafkaParameters)) {
            return false;
        }
        PipeSourceManagedStreamingKafkaParameters other = (PipeSourceManagedStreamingKafkaParameters) obj;
        return Objects.equals(batchSize(), other.batchSize()) && Objects.equals(consumerGroupID(), other.consumerGroupID())
                && Objects.equals(credentials(), other.credentials())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(startingPositionAsString(), other.startingPositionAsString())
                && Objects.equals(topicName(), other.topicName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipeSourceManagedStreamingKafkaParameters").add("BatchSize", batchSize())
                .add("ConsumerGroupID", consumerGroupID() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Credentials", credentials()).add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("StartingPosition", startingPositionAsString())
                .add("TopicName", topicName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "ConsumerGroupID":
            return Optional.ofNullable(clazz.cast(consumerGroupID()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPositionAsString()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipeSourceManagedStreamingKafkaParameters, T> g) {
        return obj -> g.apply((PipeSourceManagedStreamingKafkaParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipeSourceManagedStreamingKafkaParameters> {
        /**
         * <p>
         * The maximum number of records to include in each batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of records to include in each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The name of the destination queue to consume.
         * </p>
         * 
         * @param consumerGroupID
         *        The name of the destination queue to consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupID(String consumerGroupID);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * 
         * @param credentials
         *        The credentials needed to access the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(MSKAccessCredentials credentials);

        /**
         * <p>
         * The credentials needed to access the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link MSKAccessCredentials.Builder} avoiding
         * the need to create one manually via {@link MSKAccessCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MSKAccessCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(MSKAccessCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link MSKAccessCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(MSKAccessCredentials)
         */
        default Builder credentials(Consumer<MSKAccessCredentials.Builder> credentials) {
            return credentials(MSKAccessCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The maximum length of a time to wait for events.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum length of a time to wait for events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * (Streams only) The position in a stream from which to start reading.
         * </p>
         * 
         * @param startingPosition
         *        (Streams only) The position in a stream from which to start reading.
         * @see MSKStartPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MSKStartPosition
         */
        Builder startingPosition(String startingPosition);

        /**
         * <p>
         * (Streams only) The position in a stream from which to start reading.
         * </p>
         * 
         * @param startingPosition
         *        (Streams only) The position in a stream from which to start reading.
         * @see MSKStartPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MSKStartPosition
         */
        Builder startingPosition(MSKStartPosition startingPosition);

        /**
         * <p>
         * The name of the topic that the pipe will read from.
         * </p>
         * 
         * @param topicName
         *        The name of the topic that the pipe will read from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);
    }

    static final class BuilderImpl implements Builder {
        private Integer batchSize;

        private String consumerGroupID;

        private MSKAccessCredentials credentials;

        private Integer maximumBatchingWindowInSeconds;

        private String startingPosition;

        private String topicName;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeSourceManagedStreamingKafkaParameters model) {
            batchSize(model.batchSize);
            consumerGroupID(model.consumerGroupID);
            credentials(model.credentials);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            startingPosition(model.startingPosition);
            topicName(model.topicName);
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final String getConsumerGroupID() {
            return consumerGroupID;
        }

        public final void setConsumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
        }

        @Override
        public final Builder consumerGroupID(String consumerGroupID) {
            this.consumerGroupID = consumerGroupID;
            return this;
        }

        public final MSKAccessCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(MSKAccessCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(MSKAccessCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final String getStartingPosition() {
            return startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(MSKStartPosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        @Override
        public PipeSourceManagedStreamingKafkaParameters build() {
            return new PipeSourceManagedStreamingKafkaParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
