/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The overrides that are sent to a container. An empty container override can be passed in. An example of an empty
 * container override is <code>{"containerOverrides": [ ] }</code>. If a non-empty container override is specified, the
 * <code>name</code> parameter must be included.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsContainerOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<EcsContainerOverride.Builder, EcsContainerOverride> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Command")
            .getter(getter(EcsContainerOverride::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CPU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Cpu")
            .getter(getter(EcsContainerOverride::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()).build();

    private static final SdkField<List<EcsEnvironmentVariable>> ENVIRONMENT_FIELD = SdkField
            .<List<EcsEnvironmentVariable>> builder(MarshallingType.LIST)
            .memberName("Environment")
            .getter(getter(EcsContainerOverride::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EcsEnvironmentVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(EcsEnvironmentVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EcsEnvironmentFile>> ENVIRONMENT_FILES_FIELD = SdkField
            .<List<EcsEnvironmentFile>> builder(MarshallingType.LIST)
            .memberName("EnvironmentFiles")
            .getter(getter(EcsContainerOverride::environmentFiles))
            .setter(setter(Builder::environmentFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EcsEnvironmentFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(EcsEnvironmentFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Memory").getter(getter(EcsContainerOverride::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()).build();

    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryReservation").getter(getter(EcsContainerOverride::memoryReservation))
            .setter(setter(Builder::memoryReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryReservation").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(EcsContainerOverride::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<EcsResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<List<EcsResourceRequirement>> builder(MarshallingType.LIST)
            .memberName("ResourceRequirements")
            .getter(getter(EcsContainerOverride::resourceRequirements))
            .setter(setter(Builder::resourceRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EcsResourceRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(EcsResourceRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, CPU_FIELD,
            ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, NAME_FIELD,
            RESOURCE_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> command;

    private final Integer cpu;

    private final List<EcsEnvironmentVariable> environment;

    private final List<EcsEnvironmentFile> environmentFiles;

    private final Integer memory;

    private final Integer memoryReservation;

    private final String name;

    private final List<EcsResourceRequirement> resourceRequirements;

    private EcsContainerOverride(BuilderImpl builder) {
        this.command = builder.command;
        this.cpu = builder.cpu;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.name = builder.name;
        this.resourceRequirements = builder.resourceRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Command property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command to send to the container that overrides the default command from the Docker image or the task
     * definition. You must also specify a container name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommand} method.
     * </p>
     * 
     * @return The command to send to the container that overrides the default command from the Docker image or the task
     *         definition. You must also specify a container name.
     */
    public final List<String> command() {
        return command;
    }

    /**
     * <p>
     * The number of <code>cpu</code> units reserved for the container, instead of the default value from the task
     * definition. You must also specify a container name.
     * </p>
     * 
     * @return The number of <code>cpu</code> units reserved for the container, instead of the default value from the
     *         task definition. You must also specify a container name.
     */
    public final Integer cpu() {
        return cpu;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to send to the container. You can add new environment variables, which are added to the
     * container at launch, or you can override the existing environment variables from the Docker image or the task
     * definition. You must also specify a container name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to send to the container. You can add new environment variables, which are
     *         added to the container at launch, or you can override the existing environment variables from the Docker
     *         image or the task definition. You must also specify a container name.
     */
    public final List<EcsEnvironmentVariable> environment() {
        return environment;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentFiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentFiles() {
        return environmentFiles != null && !(environmentFiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of files containing the environment variables to pass to a container, instead of the value from the
     * container definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentFiles} method.
     * </p>
     * 
     * @return A list of files containing the environment variables to pass to a container, instead of the value from
     *         the container definition.
     */
    public final List<EcsEnvironmentFile> environmentFiles() {
        return environmentFiles;
    }

    /**
     * <p>
     * The hard limit (in MiB) of memory to present to the container, instead of the default value from the task
     * definition. If your container attempts to exceed the memory specified here, the container is killed. You must
     * also specify a container name.
     * </p>
     * 
     * @return The hard limit (in MiB) of memory to present to the container, instead of the default value from the task
     *         definition. If your container attempts to exceed the memory specified here, the container is killed. You
     *         must also specify a container name.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task
     * definition. You must also specify a container name.
     * </p>
     * 
     * @return The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the
     *         task definition. You must also specify a container name.
     */
    public final Integer memoryReservation() {
        return memoryReservation;
    }

    /**
     * <p>
     * The name of the container that receives the override. This parameter is required if any override is specified.
     * </p>
     * 
     * @return The name of the container that receives the override. This parameter is required if any override is
     *         specified.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceRequirements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceRequirements() {
        return resourceRequirements != null && !(resourceRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type and amount of a resource to assign to a container, instead of the default value from the task
     * definition. The only supported resource is a GPU.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceRequirements} method.
     * </p>
     * 
     * @return The type and amount of a resource to assign to a container, instead of the default value from the task
     *         definition. The only supported resource is a GPU.
     */
    public final List<EcsResourceRequirement> resourceRequirements() {
        return resourceRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentFiles() ? environmentFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRequirements() ? resourceRequirements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsContainerOverride)) {
            return false;
        }
        EcsContainerOverride other = (EcsContainerOverride) obj;
        return hasCommand() == other.hasCommand() && Objects.equals(command(), other.command())
                && Objects.equals(cpu(), other.cpu()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && hasEnvironmentFiles() == other.hasEnvironmentFiles()
                && Objects.equals(environmentFiles(), other.environmentFiles()) && Objects.equals(memory(), other.memory())
                && Objects.equals(memoryReservation(), other.memoryReservation()) && Objects.equals(name(), other.name())
                && hasResourceRequirements() == other.hasResourceRequirements()
                && Objects.equals(resourceRequirements(), other.resourceRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsContainerOverride").add("Command", hasCommand() ? command() : null).add("Cpu", cpu())
                .add("Environment", hasEnvironment() ? environment() : null)
                .add("EnvironmentFiles", hasEnvironmentFiles() ? environmentFiles() : null).add("Memory", memory())
                .add("MemoryReservation", memoryReservation()).add("Name", name())
                .add("ResourceRequirements", hasResourceRequirements() ? resourceRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "EnvironmentFiles":
            return Optional.ofNullable(clazz.cast(environmentFiles()));
        case "Memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "MemoryReservation":
            return Optional.ofNullable(clazz.cast(memoryReservation()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourceRequirements":
            return Optional.ofNullable(clazz.cast(resourceRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsContainerOverride, T> g) {
        return obj -> g.apply((EcsContainerOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsContainerOverride> {
        /**
         * <p>
         * The command to send to the container that overrides the default command from the Docker image or the task
         * definition. You must also specify a container name.
         * </p>
         * 
         * @param command
         *        The command to send to the container that overrides the default command from the Docker image or the
         *        task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command to send to the container that overrides the default command from the Docker image or the task
         * definition. You must also specify a container name.
         * </p>
         * 
         * @param command
         *        The command to send to the container that overrides the default command from the Docker image or the
         *        task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The number of <code>cpu</code> units reserved for the container, instead of the default value from the task
         * definition. You must also specify a container name.
         * </p>
         * 
         * @param cpu
         *        The number of <code>cpu</code> units reserved for the container, instead of the default value from the
         *        task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(Integer cpu);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition. You must also specify a container name.
         * </p>
         * 
         * @param environment
         *        The environment variables to send to the container. You can add new environment variables, which are
         *        added to the container at launch, or you can override the existing environment variables from the
         *        Docker image or the task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<EcsEnvironmentVariable> environment);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition. You must also specify a container name.
         * </p>
         * 
         * @param environment
         *        The environment variables to send to the container. You can add new environment variables, which are
         *        added to the container at launch, or you can override the existing environment variables from the
         *        Docker image or the task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EcsEnvironmentVariable... environment);

        /**
         * <p>
         * The environment variables to send to the container. You can add new environment variables, which are added to
         * the container at launch, or you can override the existing environment variables from the Docker image or the
         * task definition. You must also specify a container name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariable.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariable.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(List<EcsEnvironmentVariable>)}.
         * 
         * @param environment
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(java.util.Collection<EcsEnvironmentVariable>)
         */
        Builder environment(Consumer<EcsEnvironmentVariable.Builder>... environment);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container, instead of the value from the
         * container definition.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container, instead of the value from
         *        the container definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(Collection<EcsEnvironmentFile> environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container, instead of the value from the
         * container definition.
         * </p>
         * 
         * @param environmentFiles
         *        A list of files containing the environment variables to pass to a container, instead of the value from
         *        the container definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFiles(EcsEnvironmentFile... environmentFiles);

        /**
         * <p>
         * A list of files containing the environment variables to pass to a container, instead of the value from the
         * container definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentFile.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentFile.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentFiles(List<EcsEnvironmentFile>)}.
         * 
         * @param environmentFiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.EcsEnvironmentFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentFiles(java.util.Collection<EcsEnvironmentFile>)
         */
        Builder environmentFiles(Consumer<EcsEnvironmentFile.Builder>... environmentFiles);

        /**
         * <p>
         * The hard limit (in MiB) of memory to present to the container, instead of the default value from the task
         * definition. If your container attempts to exceed the memory specified here, the container is killed. You must
         * also specify a container name.
         * </p>
         * 
         * @param memory
         *        The hard limit (in MiB) of memory to present to the container, instead of the default value from the
         *        task definition. If your container attempts to exceed the memory specified here, the container is
         *        killed. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task
         * definition. You must also specify a container name.
         * </p>
         * 
         * @param memoryReservation
         *        The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the
         *        task definition. You must also specify a container name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryReservation(Integer memoryReservation);

        /**
         * <p>
         * The name of the container that receives the override. This parameter is required if any override is
         * specified.
         * </p>
         * 
         * @param name
         *        The name of the container that receives the override. This parameter is required if any override is
         *        specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type and amount of a resource to assign to a container, instead of the default value from the task
         * definition. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container, instead of the default value from the task
         *        definition. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(Collection<EcsResourceRequirement> resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container, instead of the default value from the task
         * definition. The only supported resource is a GPU.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of a resource to assign to a container, instead of the default value from the task
         *        definition. The only supported resource is a GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(EcsResourceRequirement... resourceRequirements);

        /**
         * <p>
         * The type and amount of a resource to assign to a container, instead of the default value from the task
         * definition. The only supported resource is a GPU.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pipes.model.EcsResourceRequirement.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.pipes.model.EcsResourceRequirement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pipes.model.EcsResourceRequirement.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceRequirements(List<EcsResourceRequirement>)}.
         * 
         * @param resourceRequirements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pipes.model.EcsResourceRequirement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequirements(java.util.Collection<EcsResourceRequirement>)
         */
        Builder resourceRequirements(Consumer<EcsResourceRequirement.Builder>... resourceRequirements);
    }

    static final class BuilderImpl implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private Integer cpu;

        private List<EcsEnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();

        private List<EcsEnvironmentFile> environmentFiles = DefaultSdkAutoConstructList.getInstance();

        private Integer memory;

        private Integer memoryReservation;

        private String name;

        private List<EcsResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsContainerOverride model) {
            command(model.command);
            cpu(model.cpu);
            environment(model.environment);
            environmentFiles(model.environmentFiles);
            memory(model.memory);
            memoryReservation(model.memoryReservation);
            name(model.name);
            resourceRequirements(model.resourceRequirements);
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final Integer getCpu() {
            return cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<EcsEnvironmentVariable.Builder> getEnvironment() {
            List<EcsEnvironmentVariable.Builder> result = EcsEnvironmentVariableListCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<EcsEnvironmentVariable.BuilderImpl> environment) {
            this.environment = EcsEnvironmentVariableListCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<EcsEnvironmentVariable> environment) {
            this.environment = EcsEnvironmentVariableListCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EcsEnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<EcsEnvironmentVariable.Builder>... environment) {
            environment(Stream.of(environment).map(c -> EcsEnvironmentVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EcsEnvironmentFile.Builder> getEnvironmentFiles() {
            List<EcsEnvironmentFile.Builder> result = EcsEnvironmentFileListCopier.copyToBuilder(this.environmentFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFiles(Collection<EcsEnvironmentFile.BuilderImpl> environmentFiles) {
            this.environmentFiles = EcsEnvironmentFileListCopier.copyFromBuilder(environmentFiles);
        }

        @Override
        public final Builder environmentFiles(Collection<EcsEnvironmentFile> environmentFiles) {
            this.environmentFiles = EcsEnvironmentFileListCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(EcsEnvironmentFile... environmentFiles) {
            environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(Consumer<EcsEnvironmentFile.Builder>... environmentFiles) {
            environmentFiles(Stream.of(environmentFiles).map(c -> EcsEnvironmentFile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<EcsResourceRequirement.Builder> getResourceRequirements() {
            List<EcsResourceRequirement.Builder> result = EcsResourceRequirementsListCopier
                    .copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<EcsResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = EcsResourceRequirementsListCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<EcsResourceRequirement> resourceRequirements) {
            this.resourceRequirements = EcsResourceRequirementsListCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(EcsResourceRequirement... resourceRequirements) {
            resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<EcsResourceRequirement.Builder>... resourceRequirements) {
            resourceRequirements(Stream.of(resourceRequirements)
                    .map(c -> EcsResourceRequirement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EcsContainerOverride build() {
            return new EcsContainerOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
