/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pipes.model.Pipe;
import software.amazon.awssdk.services.pipes.model.PipeListCopier;
import software.amazon.awssdk.services.pipes.model.PipesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipesResponse
extends PipesResponse
implements ToCopyableBuilder<Builder, ListPipesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipesResponse.getter(ListPipesResponse::nextToken)).setter(ListPipesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Pipe>> PIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pipes").getter(ListPipesResponse.getter(ListPipesResponse::pipes)).setter(ListPipesResponse.setter(Builder::pipes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Pipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PIPES_FIELD));
    private final String nextToken;
    private final List<Pipe> pipes;

    private ListPipesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pipes = builder.pipes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPipes() {
        return this.pipes != null && !(this.pipes instanceof SdkAutoConstructList);
    }

    public final List<Pipe> pipes() {
        return this.pipes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipes() ? this.pipes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipesResponse)) {
            return false;
        }
        ListPipesResponse other = (ListPipesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPipes() == other.hasPipes() && Objects.equals(this.pipes(), other.pipes());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipesResponse").add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Pipes", this.hasPipes() ? this.pipes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Pipes": {
                return Optional.ofNullable(clazz.cast(this.pipes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipesResponse, T> g) {
        return obj -> g.apply((ListPipesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PipesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Pipe> pipes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pipes(model.pipes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Pipe.Builder> getPipes() {
            List<Pipe.Builder> result = PipeListCopier.copyToBuilder(this.pipes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipes(Collection<Pipe.BuilderImpl> pipes) {
            this.pipes = PipeListCopier.copyFromBuilder(pipes);
        }

        @Override
        public final Builder pipes(Collection<Pipe> pipes) {
            this.pipes = PipeListCopier.copy(pipes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipes(Pipe ... pipes) {
            this.pipes(Arrays.asList(pipes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipes(Consumer<Pipe.Builder> ... pipes) {
            this.pipes(Stream.of(pipes).map(c -> (Pipe)((Pipe.Builder)Pipe.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPipesResponse build() {
            return new ListPipesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PipesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipesResponse> {
        public Builder nextToken(String var1);

        public Builder pipes(Collection<Pipe> var1);

        public Builder pipes(Pipe ... var1);

        public Builder pipes(Consumer<Pipe.Builder> ... var1);
    }
}

