/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestinationListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationSetInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationSetInformation> {
    private static final SdkField<String> CONFIGURATION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetArn").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::configurationSetArn)).setter(ConfigurationSetInformation.setter(Builder::configurationSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetArn").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSetName").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::configurationSetName)).setter(ConfigurationSetInformation.setter(Builder::configurationSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build()}).build();
    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventDestinations").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::eventDestinations)).setter(ConfigurationSetInformation.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultMessageType").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::defaultMessageTypeAsString)).setter(ConfigurationSetInformation.setter(Builder::defaultMessageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageType").build()}).build();
    private static final SdkField<String> DEFAULT_SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSenderId").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::defaultSenderId)).setter(ConfigurationSetInformation.setter(Builder::defaultSenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSenderId").build()}).build();
    private static final SdkField<Boolean> DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultMessageFeedbackEnabled").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::defaultMessageFeedbackEnabled)).setter(ConfigurationSetInformation.setter(Builder::defaultMessageFeedbackEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessageFeedbackEnabled").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::createdTimestamp)).setter(ConfigurationSetInformation.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(ConfigurationSetInformation.getter(ConfigurationSetInformation::protectConfigurationId)).setter(ConfigurationSetInformation.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_ARN_FIELD, CONFIGURATION_SET_NAME_FIELD, EVENT_DESTINATIONS_FIELD, DEFAULT_MESSAGE_TYPE_FIELD, DEFAULT_SENDER_ID_FIELD, DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD, CREATED_TIMESTAMP_FIELD, PROTECT_CONFIGURATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationSetInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configurationSetArn;
    private final String configurationSetName;
    private final List<EventDestination> eventDestinations;
    private final String defaultMessageType;
    private final String defaultSenderId;
    private final Boolean defaultMessageFeedbackEnabled;
    private final Instant createdTimestamp;
    private final String protectConfigurationId;

    private ConfigurationSetInformation(BuilderImpl builder) {
        this.configurationSetArn = builder.configurationSetArn;
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinations = builder.eventDestinations;
        this.defaultMessageType = builder.defaultMessageType;
        this.defaultSenderId = builder.defaultSenderId;
        this.defaultMessageFeedbackEnabled = builder.defaultMessageFeedbackEnabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.protectConfigurationId = builder.protectConfigurationId;
    }

    public final String configurationSetArn() {
        return this.configurationSetArn;
    }

    public final String configurationSetName() {
        return this.configurationSetName;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public final MessageType defaultMessageType() {
        return MessageType.fromValue(this.defaultMessageType);
    }

    public final String defaultMessageTypeAsString() {
        return this.defaultMessageType;
    }

    public final String defaultSenderId() {
        return this.defaultSenderId;
    }

    public final Boolean defaultMessageFeedbackEnabled() {
        return this.defaultMessageFeedbackEnabled;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultMessageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultMessageFeedbackEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSetInformation)) {
            return false;
        }
        ConfigurationSetInformation other = (ConfigurationSetInformation)obj;
        return Objects.equals(this.configurationSetArn(), other.configurationSetArn()) && Objects.equals(this.configurationSetName(), other.configurationSetName()) && this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations()) && Objects.equals(this.defaultMessageTypeAsString(), other.defaultMessageTypeAsString()) && Objects.equals(this.defaultSenderId(), other.defaultSenderId()) && Objects.equals(this.defaultMessageFeedbackEnabled(), other.defaultMessageFeedbackEnabled()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationSetInformation").add("ConfigurationSetArn", (Object)this.configurationSetArn()).add("ConfigurationSetName", (Object)this.configurationSetName()).add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).add("DefaultMessageType", (Object)this.defaultMessageTypeAsString()).add("DefaultSenderId", (Object)this.defaultSenderId()).add("DefaultMessageFeedbackEnabled", (Object)this.defaultMessageFeedbackEnabled()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSetArn": {
                return Optional.ofNullable(clazz.cast(this.configurationSetArn()));
            }
            case "ConfigurationSetName": {
                return Optional.ofNullable(clazz.cast(this.configurationSetName()));
            }
            case "EventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
            case "DefaultMessageType": {
                return Optional.ofNullable(clazz.cast(this.defaultMessageTypeAsString()));
            }
            case "DefaultSenderId": {
                return Optional.ofNullable(clazz.cast(this.defaultSenderId()));
            }
            case "DefaultMessageFeedbackEnabled": {
                return Optional.ofNullable(clazz.cast(this.defaultMessageFeedbackEnabled()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationSetArn", CONFIGURATION_SET_ARN_FIELD);
        map.put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
        map.put("EventDestinations", EVENT_DESTINATIONS_FIELD);
        map.put("DefaultMessageType", DEFAULT_MESSAGE_TYPE_FIELD);
        map.put("DefaultSenderId", DEFAULT_SENDER_ID_FIELD);
        map.put("DefaultMessageFeedbackEnabled", DEFAULT_MESSAGE_FEEDBACK_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("ProtectConfigurationId", PROTECT_CONFIGURATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationSetInformation, T> g) {
        return obj -> g.apply((ConfigurationSetInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationSetArn;
        private String configurationSetName;
        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();
        private String defaultMessageType;
        private String defaultSenderId;
        private Boolean defaultMessageFeedbackEnabled;
        private Instant createdTimestamp;
        private String protectConfigurationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSetInformation model) {
            this.configurationSetArn(model.configurationSetArn);
            this.configurationSetName(model.configurationSetName);
            this.eventDestinations(model.eventDestinations);
            this.defaultMessageType(model.defaultMessageType);
            this.defaultSenderId(model.defaultSenderId);
            this.defaultMessageFeedbackEnabled(model.defaultMessageFeedbackEnabled);
            this.createdTimestamp(model.createdTimestamp);
            this.protectConfigurationId(model.protectConfigurationId);
        }

        public final String getConfigurationSetArn() {
            return this.configurationSetArn;
        }

        public final void setConfigurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
        }

        @Override
        public final Builder configurationSetArn(String configurationSetArn) {
            this.configurationSetArn = configurationSetArn;
            return this;
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final List<EventDestination.Builder> getEventDestinations() {
            List<EventDestination.Builder> result = EventDestinationListCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationListCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (EventDestination)((EventDestination.Builder)EventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultMessageType() {
            return this.defaultMessageType;
        }

        public final void setDefaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
        }

        @Override
        public final Builder defaultMessageType(String defaultMessageType) {
            this.defaultMessageType = defaultMessageType;
            return this;
        }

        @Override
        public final Builder defaultMessageType(MessageType defaultMessageType) {
            this.defaultMessageType(defaultMessageType == null ? null : defaultMessageType.toString());
            return this;
        }

        public final String getDefaultSenderId() {
            return this.defaultSenderId;
        }

        public final void setDefaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
        }

        @Override
        public final Builder defaultSenderId(String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
            return this;
        }

        public final Boolean getDefaultMessageFeedbackEnabled() {
            return this.defaultMessageFeedbackEnabled;
        }

        public final void setDefaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
        }

        @Override
        public final Builder defaultMessageFeedbackEnabled(Boolean defaultMessageFeedbackEnabled) {
            this.defaultMessageFeedbackEnabled = defaultMessageFeedbackEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public ConfigurationSetInformation build() {
            return new ConfigurationSetInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationSetInformation> {
        public Builder configurationSetArn(String var1);

        public Builder configurationSetName(String var1);

        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);

        public Builder eventDestinations(Consumer<EventDestination.Builder> ... var1);

        public Builder defaultMessageType(String var1);

        public Builder defaultMessageType(MessageType var1);

        public Builder defaultSenderId(String var1);

        public Builder defaultMessageFeedbackEnabled(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder protectConfigurationId(String var1);
    }
}

