/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationAssociationBehavior;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationDisassociationBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportedAssociation> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(SupportedAssociation.getter(SupportedAssociation::resourceType)).setter(SupportedAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(SupportedAssociation.getter(SupportedAssociation::isoCountryCode)).setter(SupportedAssociation.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<String> ASSOCIATION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationBehavior").getter(SupportedAssociation.getter(SupportedAssociation::associationBehaviorAsString)).setter(SupportedAssociation.setter(Builder::associationBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationBehavior").build()}).build();
    private static final SdkField<String> DISASSOCIATION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisassociationBehavior").getter(SupportedAssociation.getter(SupportedAssociation::disassociationBehaviorAsString)).setter(SupportedAssociation.setter(Builder::disassociationBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociationBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, ISO_COUNTRY_CODE_FIELD, ASSOCIATION_BEHAVIOR_FIELD, DISASSOCIATION_BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupportedAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String isoCountryCode;
    private final String associationBehavior;
    private final String disassociationBehavior;

    private SupportedAssociation(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.isoCountryCode = builder.isoCountryCode;
        this.associationBehavior = builder.associationBehavior;
        this.disassociationBehavior = builder.disassociationBehavior;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final RegistrationAssociationBehavior associationBehavior() {
        return RegistrationAssociationBehavior.fromValue(this.associationBehavior);
    }

    public final String associationBehaviorAsString() {
        return this.associationBehavior;
    }

    public final RegistrationDisassociationBehavior disassociationBehavior() {
        return RegistrationDisassociationBehavior.fromValue(this.disassociationBehavior);
    }

    public final String disassociationBehaviorAsString() {
        return this.disassociationBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociationBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedAssociation)) {
            return false;
        }
        SupportedAssociation other = (SupportedAssociation)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && Objects.equals(this.associationBehaviorAsString(), other.associationBehaviorAsString()) && Objects.equals(this.disassociationBehaviorAsString(), other.disassociationBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SupportedAssociation").add("ResourceType", (Object)this.resourceType()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("AssociationBehavior", (Object)this.associationBehaviorAsString()).add("DisassociationBehavior", (Object)this.disassociationBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "AssociationBehavior": {
                return Optional.ofNullable(clazz.cast(this.associationBehaviorAsString()));
            }
            case "DisassociationBehavior": {
                return Optional.ofNullable(clazz.cast(this.disassociationBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
        map.put("AssociationBehavior", ASSOCIATION_BEHAVIOR_FIELD);
        map.put("DisassociationBehavior", DISASSOCIATION_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedAssociation, T> g) {
        return obj -> g.apply((SupportedAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String isoCountryCode;
        private String associationBehavior;
        private String disassociationBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedAssociation model) {
            this.resourceType(model.resourceType);
            this.isoCountryCode(model.isoCountryCode);
            this.associationBehavior(model.associationBehavior);
            this.disassociationBehavior(model.disassociationBehavior);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final String getAssociationBehavior() {
            return this.associationBehavior;
        }

        public final void setAssociationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
        }

        @Override
        public final Builder associationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
            return this;
        }

        @Override
        public final Builder associationBehavior(RegistrationAssociationBehavior associationBehavior) {
            this.associationBehavior(associationBehavior == null ? null : associationBehavior.toString());
            return this;
        }

        public final String getDisassociationBehavior() {
            return this.disassociationBehavior;
        }

        public final void setDisassociationBehavior(String disassociationBehavior) {
            this.disassociationBehavior = disassociationBehavior;
        }

        @Override
        public final Builder disassociationBehavior(String disassociationBehavior) {
            this.disassociationBehavior = disassociationBehavior;
            return this;
        }

        @Override
        public final Builder disassociationBehavior(RegistrationDisassociationBehavior disassociationBehavior) {
            this.disassociationBehavior(disassociationBehavior == null ? null : disassociationBehavior.toString());
            return this;
        }

        public SupportedAssociation build() {
            return new SupportedAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportedAssociation> {
        public Builder resourceType(String var1);

        public Builder isoCountryCode(String var1);

        public Builder associationBehavior(String var1);

        public Builder associationBehavior(RegistrationAssociationBehavior var1);

        public Builder disassociationBehavior(String var1);

        public Builder disassociationBehavior(RegistrationDisassociationBehavior var1);
    }
}

