/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimitListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountLimitsResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<List<AccountLimit>> ACCOUNT_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountLimits").getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::accountLimits)).setter(DescribeAccountLimitsResponse.setter(Builder::accountLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::nextToken)).setter(DescribeAccountLimitsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LIMITS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountLimits", ACCOUNT_LIMITS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AccountLimit> accountLimits;
    private final String nextToken;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLimits = builder.accountLimits;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountLimits() {
        return this.accountLimits != null && !(this.accountLimits instanceof SdkAutoConstructList);
    }

    public final List<AccountLimit> accountLimits() {
        return this.accountLimits;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountLimits() ? this.accountLimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        return this.hasAccountLimits() == other.hasAccountLimits() && Objects.equals(this.accountLimits(), other.accountLimits()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountLimitsResponse").add("AccountLimits", this.hasAccountLimits() ? this.accountLimits() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountLimits": {
                return Optional.ofNullable(clazz.cast(this.accountLimits()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private List<AccountLimit> accountLimits = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            this.accountLimits(model.accountLimits);
            this.nextToken(model.nextToken);
        }

        public final List<AccountLimit.Builder> getAccountLimits() {
            List<AccountLimit.Builder> result = AccountLimitListCopier.copyToBuilder(this.accountLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountLimits(Collection<AccountLimit.BuilderImpl> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copyFromBuilder(accountLimits);
        }

        @Override
        public final Builder accountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(AccountLimit ... accountLimits) {
            this.accountLimits(Arrays.asList(accountLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(Consumer<AccountLimit.Builder> ... accountLimits) {
            this.accountLimits(Stream.of(accountLimits).map(c -> (AccountLimit)((AccountLimit.Builder)AccountLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder accountLimits(Collection<AccountLimit> var1);

        public Builder accountLimits(AccountLimit ... var1);

        public Builder accountLimits(Consumer<AccountLimit.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

