/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapabilityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginationIdentityMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginationIdentityMetadata> {
    private static final SdkField<String> ORIGINATION_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentityArn").getter(OriginationIdentityMetadata.getter(OriginationIdentityMetadata::originationIdentityArn)).setter(OriginationIdentityMetadata.setter(Builder::originationIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentityArn").build()}).build();
    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationIdentity").getter(OriginationIdentityMetadata.getter(OriginationIdentityMetadata::originationIdentity)).setter(OriginationIdentityMetadata.setter(Builder::originationIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(OriginationIdentityMetadata.getter(OriginationIdentityMetadata::isoCountryCode)).setter(OriginationIdentityMetadata.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<List<String>> NUMBER_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberCapabilities").getter(OriginationIdentityMetadata.getter(OriginationIdentityMetadata::numberCapabilitiesAsStrings)).setter(OriginationIdentityMetadata.setter(Builder::numberCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(OriginationIdentityMetadata.getter(OriginationIdentityMetadata::phoneNumber)).setter(OriginationIdentityMetadata.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_IDENTITY_ARN_FIELD, ORIGINATION_IDENTITY_FIELD, ISO_COUNTRY_CODE_FIELD, NUMBER_CAPABILITIES_FIELD, PHONE_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OriginationIdentityArn", ORIGINATION_IDENTITY_ARN_FIELD);
            this.put("OriginationIdentity", ORIGINATION_IDENTITY_FIELD);
            this.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
            this.put("NumberCapabilities", NUMBER_CAPABILITIES_FIELD);
            this.put("PhoneNumber", PHONE_NUMBER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String originationIdentityArn;
    private final String originationIdentity;
    private final String isoCountryCode;
    private final List<String> numberCapabilities;
    private final String phoneNumber;

    private OriginationIdentityMetadata(BuilderImpl builder) {
        this.originationIdentityArn = builder.originationIdentityArn;
        this.originationIdentity = builder.originationIdentity;
        this.isoCountryCode = builder.isoCountryCode;
        this.numberCapabilities = builder.numberCapabilities;
        this.phoneNumber = builder.phoneNumber;
    }

    public final String originationIdentityArn() {
        return this.originationIdentityArn;
    }

    public final String originationIdentity() {
        return this.originationIdentity;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final List<NumberCapability> numberCapabilities() {
        return NumberCapabilityListCopier.copyStringToEnum(this.numberCapabilities);
    }

    public final boolean hasNumberCapabilities() {
        return this.numberCapabilities != null && !(this.numberCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> numberCapabilitiesAsStrings() {
        return this.numberCapabilities;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginationIdentityMetadata)) {
            return false;
        }
        OriginationIdentityMetadata other = (OriginationIdentityMetadata)obj;
        return Objects.equals(this.originationIdentityArn(), other.originationIdentityArn()) && Objects.equals(this.originationIdentity(), other.originationIdentity()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && this.hasNumberCapabilities() == other.hasNumberCapabilities() && Objects.equals(this.numberCapabilitiesAsStrings(), other.numberCapabilitiesAsStrings()) && Objects.equals(this.phoneNumber(), other.phoneNumber());
    }

    public final String toString() {
        return ToString.builder((String)"OriginationIdentityMetadata").add("OriginationIdentityArn", (Object)this.originationIdentityArn()).add("OriginationIdentity", (Object)this.originationIdentity()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("NumberCapabilities", this.hasNumberCapabilities() ? this.numberCapabilitiesAsStrings() : null).add("PhoneNumber", (Object)this.phoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginationIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.originationIdentityArn()));
            }
            case "OriginationIdentity": {
                return Optional.ofNullable(clazz.cast(this.originationIdentity()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "NumberCapabilities": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilitiesAsStrings()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OriginationIdentityMetadata, T> g) {
        return obj -> g.apply((OriginationIdentityMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String originationIdentityArn;
        private String originationIdentity;
        private String isoCountryCode;
        private List<String> numberCapabilities = DefaultSdkAutoConstructList.getInstance();
        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginationIdentityMetadata model) {
            this.originationIdentityArn(model.originationIdentityArn);
            this.originationIdentity(model.originationIdentity);
            this.isoCountryCode(model.isoCountryCode);
            this.numberCapabilitiesWithStrings(model.numberCapabilities);
            this.phoneNumber(model.phoneNumber);
        }

        public final String getOriginationIdentityArn() {
            return this.originationIdentityArn;
        }

        public final void setOriginationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
        }

        @Override
        public final Builder originationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
            return this;
        }

        public final String getOriginationIdentity() {
            return this.originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Collection<String> getNumberCapabilities() {
            if (this.numberCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.numberCapabilities;
        }

        public final void setNumberCapabilities(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
        }

        @Override
        public final Builder numberCapabilitiesWithStrings(Collection<String> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copy(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilitiesWithStrings(String ... numberCapabilities) {
            this.numberCapabilitiesWithStrings(Arrays.asList(numberCapabilities));
            return this;
        }

        @Override
        public final Builder numberCapabilities(Collection<NumberCapability> numberCapabilities) {
            this.numberCapabilities = NumberCapabilityListCopier.copyEnumToString(numberCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberCapabilities(NumberCapability ... numberCapabilities) {
            this.numberCapabilities(Arrays.asList(numberCapabilities));
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public OriginationIdentityMetadata build() {
            return new OriginationIdentityMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginationIdentityMetadata> {
        public Builder originationIdentityArn(String var1);

        public Builder originationIdentity(String var1);

        public Builder isoCountryCode(String var1);

        public Builder numberCapabilitiesWithStrings(Collection<String> var1);

        public Builder numberCapabilitiesWithStrings(String ... var1);

        public Builder numberCapabilities(Collection<NumberCapability> var1);

        public Builder numberCapabilities(NumberCapability ... var1);

        public Builder phoneNumber(String var1);
    }
}

