/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;

public class DescribeConfigurationSetsIterable
implements SdkIterable<DescribeConfigurationSetsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeConfigurationSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConfigurationSetsIterable(PinpointSmsVoiceV2Client client, DescribeConfigurationSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConfigurationSetsResponseFetcher();
    }

    public Iterator<DescribeConfigurationSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationSetInformation> configurationSets() {
        Function<DescribeConfigurationSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationSets() != null) {
                return response.configurationSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConfigurationSetsResponseFetcher
    implements SyncPageFetcher<DescribeConfigurationSetsResponse> {
        private DescribeConfigurationSetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConfigurationSetsResponse nextPage(DescribeConfigurationSetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationSetsIterable.this.client.describeConfigurationSets(DescribeConfigurationSetsIterable.this.firstRequest);
            }
            return DescribeConfigurationSetsIterable.this.client.describeConfigurationSets((DescribeConfigurationSetsRequest)((Object)DescribeConfigurationSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

