/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the
 * same resource at the same time or it could be that the requested action isn't valid for the current state or
 * configuration of the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends PinpointSmsVoiceV2Exception implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ConflictException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ConflictException::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ConflictException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String resourceType;

    private final String resourceId;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The reason for the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the exception.
     * @see ConflictExceptionReason
     */
    public ConflictExceptionReason reason() {
        return ConflictExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the exception.
     * @see ConflictExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The type of resource that caused the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that caused the exception.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource that caused the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource that caused the exception.
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The unique identifier of the request.
     * </p>
     * 
     * @return The unique identifier of the request.
     */
    public String resourceId() {
        return resourceId;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, PinpointSmsVoiceV2Exception.Builder {
        /**
         * <p>
         * The reason for the exception.
         * </p>
         * 
         * @param reason
         *        The reason for the exception.
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for the exception.
         * </p>
         * 
         * @param reason
         *        The reason for the exception.
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(ConflictExceptionReason reason);

        /**
         * <p>
         * The type of resource that caused the exception.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that caused the exception.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource that caused the exception.
         * </p>
         * 
         * @param resourceType
         *        The type of resource that caused the exception.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The unique identifier of the request.
         * </p>
         * 
         * @param resourceId
         *        The unique identifier of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Exception.BuilderImpl implements Builder {
        private String reason;

        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            reason(model.reason);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ConflictExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
