/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation;

public class DescribeSenderIdsPublisher
implements SdkPublisher<DescribeSenderIdsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeSenderIdsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSenderIdsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeSenderIdsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSenderIdsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeSenderIdsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSenderIdsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSenderIdsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SenderIdInformation> senderIds() {
        Function<DescribeSenderIdsResponse, Iterator> getIterator = response -> {
            if (response != null && response.senderIds() != null) {
                return response.senderIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSenderIdsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSenderIdsResponseFetcher
    implements AsyncPageFetcher<DescribeSenderIdsResponse> {
        private DescribeSenderIdsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSenderIdsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSenderIdsResponse> nextPage(DescribeSenderIdsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSenderIdsPublisher.this.client.describeSenderIds(DescribeSenderIdsPublisher.this.firstRequest);
            }
            return DescribeSenderIdsPublisher.this.client.describeSenderIds((DescribeSenderIdsRequest)((Object)DescribeSenderIdsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

