/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation;

public class DescribeKeywordsIterable
implements SdkIterable<DescribeKeywordsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeKeywordsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeKeywordsIterable(PinpointSmsVoiceV2Client client, DescribeKeywordsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeKeywordsResponseFetcher();
    }

    public Iterator<DescribeKeywordsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KeywordInformation> keywords() {
        Function<DescribeKeywordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.keywords() != null) {
                return response.keywords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeKeywordsResponseFetcher
    implements SyncPageFetcher<DescribeKeywordsResponse> {
        private DescribeKeywordsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeKeywordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeKeywordsResponse nextPage(DescribeKeywordsResponse previousPage) {
            if (previousPage == null) {
                return DescribeKeywordsIterable.this.client.describeKeywords(DescribeKeywordsIterable.this.firstRequest);
            }
            return DescribeKeywordsIterable.this.client.describeKeywords((DescribeKeywordsRequest)((Object)DescribeKeywordsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

