/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that contains information about the configuration sets for your account in the current region.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationSetsResponse extends PinpointSmsVoiceResponse implements
        ToCopyableBuilder<ListConfigurationSetsResponse.Builder, ListConfigurationSetsResponse> {
    private static final SdkField<List<String>> CONFIGURATION_SETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationSets")
            .getter(getter(ListConfigurationSetsResponse::configurationSets))
            .setter(setter(Builder::configurationSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> configurationSets;

    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConfigurationSets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConfigurationSets() {
        return configurationSets != null && !(configurationSets instanceof SdkAutoConstructList);
    }

    /**
     * An object that contains a list of configuration sets for your account in the current region.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigurationSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that contains a list of configuration sets for your account in the current region.
     */
    public final List<String> configurationSets() {
        return configurationSets;
    }

    /**
     * A token returned from a previous call to ListConfigurationSets to indicate the position in the list of
     * configuration sets.
     * 
     * @return A token returned from a previous call to ListConfigurationSets to indicate the position in the list of
     *         configuration sets.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationSets() ? configurationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse) obj;
        return hasConfigurationSets() == other.hasConfigurationSets()
                && Objects.equals(configurationSets(), other.configurationSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigurationSetsResponse")
                .add("ConfigurationSets", hasConfigurationSets() ? configurationSets() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSets":
            return Optional.ofNullable(clazz.cast(configurationSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationSetsResponse, T> g) {
        return obj -> g.apply((ListConfigurationSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        /**
         * An object that contains a list of configuration sets for your account in the current region.
         * 
         * @param configurationSets
         *        An object that contains a list of configuration sets for your account in the current region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(Collection<String> configurationSets);

        /**
         * An object that contains a list of configuration sets for your account in the current region.
         * 
         * @param configurationSets
         *        An object that contains a list of configuration sets for your account in the current region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(String... configurationSets);

        /**
         * A token returned from a previous call to ListConfigurationSets to indicate the position in the list of
         * configuration sets.
         * 
         * @param nextToken
         *        A token returned from a previous call to ListConfigurationSets to indicate the position in the list of
         *        configuration sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceResponse.BuilderImpl implements Builder {
        private List<String> configurationSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            super(model);
            configurationSets(model.configurationSets);
            nextToken(model.nextToken);
        }

        public final Collection<String> getConfigurationSets() {
            if (configurationSets instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationSets;
        }

        @Override
        public final Builder configurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(String... configurationSets) {
            configurationSets(Arrays.asList(configurationSets));
            return this;
        }

        public final void setConfigurationSets(Collection<String> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
