/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that contains information about an event destination that sends data to Amazon CloudWatch Logs.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsDestination.Builder, CloudWatchLogsDestination> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsDestination::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsDestination::logGroupArn)).setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            LOG_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final String logGroupArn;

    private CloudWatchLogsDestination(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.logGroupArn = builder.logGroupArn;
    }

    /**
     * The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write event
     * data to an Amazon CloudWatch destination.
     * 
     * @return The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to
     *         write event data to an Amazon CloudWatch destination.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * The name of the Amazon CloudWatch Log Group that you want to record events in.
     * 
     * @return The name of the Amazon CloudWatch Log Group that you want to record events in.
     */
    public String logGroupArn() {
        return logGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsDestination)) {
            return false;
        }
        CloudWatchLogsDestination other = (CloudWatchLogsDestination) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(logGroupArn(), other.logGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudWatchLogsDestination").add("IamRoleArn", iamRoleArn()).add("LogGroupArn", logGroupArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsDestination, T> g) {
        return obj -> g.apply((CloudWatchLogsDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsDestination> {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to write
         * event data to an Amazon CloudWatch destination.
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM) role that is able to
         *        write event data to an Amazon CloudWatch destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * The name of the Amazon CloudWatch Log Group that you want to record events in.
         * 
         * @param logGroupArn
         *        The name of the Amazon CloudWatch Log Group that you want to record events in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private String logGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsDestination model) {
            iamRoleArn(model.iamRoleArn);
            logGroupArn(model.logGroupArn);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public CloudWatchLogsDestination build() {
            return new CloudWatchLogsDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
